package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.type.SyncTriggerType;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataMap;

public class MetaDataMapAction extends MetaUserTaskAction<MetaDataMap> {

	@Override
	public void load(Document doc, Element node, MetaDataMap meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setSyncTriggerType(SyncTriggerType.parseString(DomHelper.readAttr(node, BPMConstants.NODE_SYNC_TRIGGER_TYPE, SyncTriggerType.STR_NO_OPT)));
		meta.setMidDataMap(DomHelper.readAttr(node, BPMConstants.NODE_MID_DATA_MAP, false));
		meta.setDataMapCondition(DomHelper.readAttr(node, BPMConstants.NODE_DATA_MAP_CONDITION, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaDataMap meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_SYNC_TRIGGER_TYPE, SyncTriggerType.formatString(meta.getSyncTriggerType()), SyncTriggerType.STR_NO_OPT);
		DomHelper.writeAttr(node, BPMConstants.NODE_MID_DATA_MAP, meta.getMidDataMap(), false);
		DomHelper.writeAttr(node, BPMConstants.NODE_DATA_MAP_CONDITION, meta.getDataMapCondition(), "");
	}

}
