package com.bokesoft.yes.meta.persist.dom.bpm.action.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend.MetaItems;


public class MetaItemsAction<T extends MetaItems> extends BaseDomAction<T> {

	@Override
	public void load(Document document, Element element, T meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, BPMConstants.COMMON_KEY, ""));
		meta.setDescription(DomHelper.readAttr(element, BPMConstants.COMMON_DESCRIPTION, ""));
		
	}
	
	@Override
	public void save(Document document, Element element, T meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, BPMConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
	}
}
