package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;

public class MetaSourceParaAction extends BaseDomAction<MetaSourcePara> {

	@Override
	public void load(Document document, Element element, MetaSourcePara meta, int runType) {
		meta.setParaKey(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_PARA_KEY, ""));
		meta.setParaValue(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_PARA_VALUE, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaSourcePara meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_PARA_KEY, meta.getParaKey(), "");
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_PARA_VALUE, meta.getParaValue(), "");
		
	}
}
