package com.bokesoft.yes.meta.persist.dom.archive;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ArchiveDBSecondType;
import com.bokesoft.yigo.common.def.ArchiveDBType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.archive.MetaArchiveTarget;

public class MetaArchiveTargetAction extends BaseDomAction<MetaArchiveTarget> {

	@Override
	public void load(Document document, Element element, MetaArchiveTarget meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setType(ArchiveDBType.parse(DomHelper.readAttr(element, MetaArchiveConstants.TYPE, ArchiveDBType.STR_RMDB)));
		meta.setSecondType(ArchiveDBSecondType.parse(DomHelper.readAttr(element, MetaArchiveConstants.SECOND_TYPE, ArchiveDBSecondType.STR_HBASE)));
		meta.setDsn(DomHelper.readAttr(element, MetaArchiveConstants.DSN, ""));
		meta.setProvider(DomHelper.readAttr(element, MetaArchiveConstants.PROVIDER, ""));
		
	}

	@Override
	public void save(Document document, Element element, MetaArchiveTarget meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(),"");
		DomHelper.writeAttr(element, MetaArchiveConstants.TYPE, ArchiveDBType.toString(meta.getType()), ArchiveDBType.STR_RMDB);
		DomHelper.writeAttr(element, MetaArchiveConstants.SECOND_TYPE, ArchiveDBSecondType.toString(meta.getSecondType()), ArchiveDBSecondType.STR_HBASE);
		DomHelper.writeAttr(element, MetaArchiveConstants.DSN, meta.getDsn(), "");
		DomHelper.writeAttr(element, MetaArchiveConstants.PROVIDER, meta.getProvider(), "");
		
	}

}
