package com.bokesoft.yes.meta.persist.dom.archive;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ArchiveType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.archive.MetaArchiveRule;

public class MetaArchiveRuleAction extends BaseDomAction<MetaArchiveRule> {

	@Override
	public void load(Document document, Element element, MetaArchiveRule meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		String str = DomHelper.readAttr(element, MetaArchiveConstants.TYPE, ArchiveType.STR_NORMAL);
		meta.setType(ArchiveType.parse(str));
	}

	@Override
	public void save(Document document, Element element, MetaArchiveRule meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		String str = ArchiveType.toString(meta.getType());
		DomHelper.writeAttr(element, MetaArchiveConstants.TYPE, str, ArchiveType.STR_NORMAL);
	}

}
