package com.bokesoft.yes.meta.persist.dom;

import java.util.HashMap;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaActionMap;

public abstract class MetaActionMap implements IMetaActionMap {
	private HashMap<String, IMetaAction<AbstractMetaObject>> actionMap = null;
	private HashMap<String, HashMap<String, IMetaAction<AbstractMetaObject>>> hostActionMap = null;
	
	public MetaActionMap() {
		actionMap = new HashMap<String, IMetaAction<AbstractMetaObject>>();
		Object[][] actionLookupTable = this.getActionLookupTable();
		if (actionLookupTable != null) {
			createMap(actionMap, actionLookupTable);
		}
		Object[][] hostActionLookupTable = this.getHostActionLookupTable();
		if ( hostActionLookupTable != null ) {
			hostActionMap = new HashMap<String, HashMap<String, IMetaAction<AbstractMetaObject>>>();
			int length = hostActionLookupTable.length;
			for ( int i = 0; i<length; ++i ) {
				String tagName = (String)hostActionLookupTable[i][0];
				Object[][] table = (Object[][])hostActionLookupTable[i][1];
				HashMap<String, IMetaAction<AbstractMetaObject>> map = new HashMap<String, IMetaAction<AbstractMetaObject>>();
				createMap(map, table);
				hostActionMap.put(tagName, map);
			}
		}
	}
	
	private static void createMap(HashMap<String, IMetaAction<AbstractMetaObject>> map, Object[][] table) {
		int length = table.length;
		Object[] line = null;
		for (int i = 0; i < length; ++i) {
			line = table[i];
			String tagName = (String) line[0];
			@SuppressWarnings("unchecked")
			IMetaAction<AbstractMetaObject> action = (IMetaAction<AbstractMetaObject>) line[1];
			map.put(tagName, action);
		}
	}
	
	@Override
	public IMetaAction<AbstractMetaObject> getAction(String tag) {
		return actionMap.get(tag);
	}
	
	@Override
	public IMetaAction<AbstractMetaObject> getAction(String parentTag, String tag) {
		if ( hostActionMap == null ) return null;
		IMetaAction<AbstractMetaObject> action = null;
		HashMap<String, IMetaAction<AbstractMetaObject>> map = hostActionMap.get(parentTag);
		action = map != null ? map.get(tag) : null;
		return action;
	}

	/**
	 * 获取一个二维数组：此二维表存储了所有数据对象的标签名和操作数据对象的动作对象，便于查找

	 * <pre>
	 * 第一列：对象的标签名
	 * 第二列：数据对象的动作
	 * </pre>
	 * 
	 * @return 二维数组
	 */
	protected abstract Object[][] getActionLookupTable();
	
	/**
	 * 以{key,Object[][]}形式表示的二维数据
	 * @return 二维数组
	 */
	protected abstract Object[][] getHostActionLookupTable();
}
