package com.bokesoft.yes.meta.persist.dom;

import java.util.Iterator;
import java.util.Map.Entry;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaEnv;

public abstract class BaseDomAction<T extends AbstractMetaObject> implements IMetaAction<T> {
		
	public void process(IMetaEnv env, Object doc, Object node, T meta, Object flag, int runType) {
		
		if ( (Boolean)flag ) {
			
			preSave((Document)doc, (Element)node, meta, runType);
		
			save((Document)doc, (Element)node, meta, runType);				
			
		} else {
			
			preLoad((Document)doc, (Element)node, meta, runType);
		
			load((Document)doc, (Element)node, meta, runType);
		}
	}
		
	private void preSave(Document document, Element element, T meta, int runType){
		if( runType != AppRunType.Dev ) 
			return;
		Iterator<Entry<String, String>> iterator = meta.attIterator();
		while( iterator.hasNext() ) {
			Entry<String, String> entry = iterator.next();
			element.setAttribute(entry.getKey(), entry.getValue());
		}
	}
	
	private void preLoad(Document document, Element element, T meta, int runType) {
		if( runType != AppRunType.Dev ) 
			return;
		NamedNodeMap nodeMap = element.getAttributes();
		for( int i = 0;i < nodeMap.getLength();i++ ) {
			Attr attr = (Attr)nodeMap.item(i);
			meta.addAttribute(attr.getName(),attr.getValue());
		}
	}
		
	public abstract void load(Document document, Element element, T meta, int runType);
		
	public abstract void save(Document document, Element element, T meta, int runType);
	
}
