/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.control.tableview;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;
import java.util.LinkedList;

public class MetaTableView
extends MetaComponent {
    public static final String TAG_NAME = "TableView";
    private MetaTableRowCollection rows = null;
    private Boolean indicator = false;
    private Boolean hoverHead = false;
    private String itemAnim = "FadeIn";
    private String layoutAnim;

    public Boolean isIndicator() {
        return this.indicator;
    }

    public void setIndicator(Boolean indicator) {
        this.indicator = indicator;
    }

    public Boolean isHoverHead() {
        return this.hoverHead;
    }

    public void setHoverHead(Boolean hoverHead) {
        this.hoverHead = hoverHead;
    }

    public String getItemAnim() {
        return this.itemAnim;
    }

    public void setItemAnim(String itemAnim) {
        this.itemAnim = itemAnim;
    }

    public String getLayoutAnim() {
        return this.layoutAnim;
    }

    public void setLayoutAnim(String layoutAnim) {
        this.layoutAnim = layoutAnim;
    }

    @Override
    public int getControlType() {
        return 264;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        this.addAll(list, new Object[]{this.rows});
    }

    @Override
    public AbstractMetaObject getProperties() {
        return null;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public MetaTableView newInstance() {
        return new MetaTableView();
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if (resultMetaObject == null && "TableRowCollection".equals(tagName)) {
            this.rows = new MetaTableRowCollection();
            resultMetaObject = this.rows;
        }
        return resultMetaObject;
    }

    public MetaTableRowCollection getRows() {
        return this.rows;
    }

    public void setRows(MetaTableRowCollection rows) {
        this.rows = rows;
    }

    @Override
    public MetaTableView clone() {
        MetaTableView newObject = (MetaTableView)super.clone();
        newObject.setRows(this.rows == null ? null : (MetaTableRowCollection)this.rows.clone());
        newObject.setIndicator(this.indicator);
        newObject.setHoverHead(this.hoverHead);
        newObject.setItemAnim(this.itemAnim);
        newObject.setLayoutAnim(this.layoutAnim);
        return newObject;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if (this.rows != null) {
            boolean hasIndicatorGroupRow = false;
            boolean hasHoverHeadGroupRow = false;
            int size = this.rows.size();
            for (int i = 0; i < size; ++i) {
                MetaTableRow element = (MetaTableRow)this.rows.get(i);
                if (element.getRowType() == 1) {
                    int nextIndex = i + 1;
                    if (nextIndex == size || ((MetaTableRow)this.rows.get(nextIndex)).getRowType() != 2) {
                        element.setRowType(0);
                    } else {
                        if (element.isIndicator().booleanValue()) {
                            if (hasIndicatorGroupRow) {
                                throw new MetaException(132, SimpleStringFormat.format((String)StringTable.getString(null, "", "TableViewOnlyAllowOneGroupRowHasIndicator"), (Object[])new Object[]{this.getKey()}));
                            }
                            hasIndicatorGroupRow = true;
                        }
                        if (element.isHoverHead().booleanValue()) {
                            hasHoverHeadGroupRow = true;
                        }
                        element.setTableKey(((MetaTableRow)this.rows.get(nextIndex)).getTableKey());
                    }
                } else if (element.getRowType() == 3) {
                    int beforeIndex = i - 1;
                    if (beforeIndex < 0 || ((MetaTableRow)this.rows.get(beforeIndex)).getRowType() != 2) {
                        element.setRowType(0);
                    } else {
                        element.setTableKey(((MetaTableRow)this.rows.get(beforeIndex)).getTableKey());
                    }
                }
                element.doPostProcess(flag, callback);
            }
            this.indicator = hasIndicatorGroupRow;
            this.hoverHead = hasHoverHeadGroupRow;
        }
    }
}

