/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;

public class MetaFormMergeHandler {
    public static MetaMobileDef getMobileDefInProject(IMetaFactory metaFactory, String projectKey) {
        MetaMobileDef projectMobileDef = null;
        try {
            projectMobileDef = metaFactory.getMobileDef(projectKey);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return projectMobileDef;
    }

    public static MetaMobileDef getMobileDefInSolution(IMetaFactory metaFactory) {
        MetaMobileDef solutionMobileDef = null;
        try {
            solutionMobileDef = metaFactory.getMobileDef(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return solutionMobileDef;
    }

    public static void preMergeMetaObject(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        if (metaForm == null) {
            return;
        }
        String projectKey = metaForm.getProjectKey();
        MetaMobileDef projectMobileDef = MetaFormMergeHandler.getMobileDefInProject(metaFactory, projectKey);
        MetaMobileDef solutionMobileDef = MetaFormMergeHandler.getMobileDefInSolution(metaFactory);
        if (metaForm.getMetaNavigation() == null) {
            MetaNavigationBar solutionNavigationBar;
            if (projectMobileDef != null) {
                // empty if block
            }
            MetaNavigationBar projectNavigationBar = projectMobileDef == null ? null : projectMobileDef.getNavigationBar();
            MetaNavigationBar metaNavigationBar = solutionNavigationBar = solutionMobileDef == null ? null : solutionMobileDef.getNavigationBar();
            if (projectNavigationBar != null || solutionNavigationBar != null) {
                MetaNavigationBar metaNav = new MetaNavigationBar();
                metaNav.mergePropertiesWithMobileDef(projectNavigationBar, solutionNavigationBar);
                metaForm.setNavigation(new MetaNavigationBar());
            }
        }
    }

    public static void mergeCommonPropertiesWithMobileDef(IMetaFactory metaFactory, MetaForm metaForm) {
        MetaAnimItem item;
        int i;
        MetaAnimCollection solutionAnimCollection;
        if (metaForm == null) {
            return;
        }
        String projectKey = metaForm.getProjectKey();
        MetaMobileDef projectMobileDef = MetaFormMergeHandler.getMobileDefInProject(metaFactory, projectKey);
        MetaMobileDef solutionMobileDef = MetaFormMergeHandler.getMobileDefInSolution(metaFactory);
        String hasNavigationBar = metaForm.isHasNavigationBar();
        if (hasNavigationBar.isEmpty() && projectMobileDef != null) {
            hasNavigationBar = projectMobileDef.getHasNavigationBar();
        }
        if (hasNavigationBar.isEmpty() && solutionMobileDef != null) {
            hasNavigationBar = solutionMobileDef.getHasNavigationBar();
        }
        metaForm.setHasNavigationBar(hasNavigationBar);
        Boolean disableKeyboard = metaForm.isDisableKeyboard();
        if (disableKeyboard == null && projectMobileDef != null) {
            disableKeyboard = projectMobileDef.isDisableKeyboard();
        }
        if (disableKeyboard == null && solutionMobileDef != null) {
            disableKeyboard = solutionMobileDef.isDisableKeyboard();
        }
        metaForm.setDisableKeyboard(disableKeyboard);
        MetaAnimCollection animCollection = metaForm.getAnimCollection();
        MetaAnimCollection projectAnimCollection = projectMobileDef == null ? null : projectMobileDef.getAnimCollection();
        MetaAnimCollection metaAnimCollection = solutionAnimCollection = solutionMobileDef == null ? null : solutionMobileDef.getAnimCollection();
        if (animCollection == null) {
            animCollection = new MetaAnimCollection();
        }
        if (projectAnimCollection != null && projectAnimCollection.size() > 0) {
            for (i = 0; i < projectAnimCollection.size(); ++i) {
                item = (MetaAnimItem)projectAnimCollection.get(i);
                animCollection.add(item);
            }
        }
        if (solutionAnimCollection != null && solutionAnimCollection.size() > 0) {
            for (i = 0; i < solutionAnimCollection.size(); ++i) {
                item = (MetaAnimItem)solutionAnimCollection.get(i);
                animCollection.add(item);
            }
        }
        metaForm.setAnimCollection(animCollection.size() == 0 ? null : animCollection);
        int fullScreenType = metaForm.getFullScreenType();
        if (fullScreenType == -1) {
            if (projectMobileDef != null) {
                fullScreenType = projectMobileDef.getFullscreenType();
            }
            if (fullScreenType == -1 && solutionMobileDef != null) {
                fullScreenType = solutionMobileDef.getFullscreenType();
            }
        }
        metaForm.setFullScreenType(fullScreenType);
        String statusBarColor = metaForm.getStatusBarColor();
        if (statusBarColor == null) {
            if (projectMobileDef != null) {
                statusBarColor = projectMobileDef.getStatusBarColor();
            }
            if (statusBarColor == null && solutionMobileDef != null) {
                statusBarColor = solutionMobileDef.getStatusBarColor();
            }
        }
        metaForm.setStatusBarColor(statusBarColor);
        MetaWatermark watermark = metaForm.getWatermark();
        if (watermark == null) {
            if (projectMobileDef != null) {
                watermark = projectMobileDef.getWatermark();
            }
            if (watermark == null && solutionMobileDef != null) {
                watermark = solutionMobileDef.getWatermark();
            }
        }
        metaForm.setWatermark(watermark);
    }
}

