/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.annotation.DataElementAttribute;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.util.MetaAnnotationUtil;
import java.util.LinkedList;

public class MetaColumn
extends KeyPairMetaObject {
    private static final long serialVersionUID = 1L;
    private String key = "";
    private String caption = "";
    private String defaultValue = null;
    private String defaultFormulaValue = "";
    private String description = "";
    private Boolean persist = true;
    private Boolean ignoreSave = false;
    private Boolean ignoreQuery = false;
    private Boolean ignoreModify = false;
    private String dbColumnName = "";
    @DataElementAttribute
    private Integer dataType = -1;
    @DataElementAttribute
    private Integer length = 0;
    @DataElementAttribute
    private Integer precision = 0;
    @DataElementAttribute
    private Integer scale = 0;
    private Boolean localTimeZone = false;
    private Boolean isPrimary = false;
    private Boolean cache = false;
    private Integer needRights = 0;
    private String itemKey = "";
    private Boolean isExpand = false;
    private MetaBaseScript expandSource = null;
    private Boolean hidden = false;
    private Integer groupType = -1;
    private Integer periodGranularity = -1;
    private Integer splitType = -1;
    private String periodImpl = "";
    private Boolean autoGen = false;
    private Boolean accessControl = false;
    private Boolean systemControlField = false;
    private Integer sort = 0;
    private Boolean isPrimaryKey = false;
    private MetaTable table = null;
    private String userTag = "";
    private Boolean supportI18n = false;
    private String codeColumnKey = "";
    private String dataElementKey = null;
    private MetaDataElement dataElement = null;
    private String refCol = null;
    private String refItemKeyCol = null;
    public static final String TAG_NAME = "Column";

    public void setTable(MetaTable table) {
        this.table = table;
    }

    public MetaTable getTable() {
        return this.table;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll(list, new AbstractMetaObject[]{this.expandSource});
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaBaseScript resultMetaObject = null;
        if ("ExpandSource".equals(tagName)) {
            resultMetaObject = this.expandSource = new MetaBaseScript("ExpandSource");
        }
        return resultMetaObject;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isPersist() {
        return this.persist;
    }

    public String getDBColumnName() {
        return this.dbColumnName;
    }

    public String getBindingDBColumnName() {
        return this.dbColumnName != null && !this.dbColumnName.isEmpty() ? this.dbColumnName : this.key;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPersist(Boolean persist) {
        this.persist = persist;
    }

    public void setDBColumnName(String dbColumnName) {
        this.dbColumnName = dbColumnName;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        if (null != length && length == 1) {
            length = StringUtil.OneBlank_STRING_Length;
        }
        this.length = length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setLocalTimeZone(Boolean localTimeZone) {
        this.localTimeZone = localTimeZone;
    }

    public Boolean isLocalTimeZone() {
        return this.localTimeZone;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setDefaultFormulaValue(String defaultFormulaValue) {
        this.defaultFormulaValue = defaultFormulaValue;
    }

    public String getDefaultFormulaValue() {
        return this.defaultFormulaValue;
    }

    public void setNeedRights(Integer needRights) {
        this.needRights = needRights;
    }

    public Integer getNeedRights() {
        return this.needRights;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setExpand(Boolean isExpand) {
        this.isExpand = isExpand;
    }

    public Boolean isExpand() {
        return this.isExpand;
    }

    public void setExpandSource(MetaBaseScript expandSource) {
        this.expandSource = expandSource;
    }

    public MetaBaseScript getExpandSource() {
        return this.expandSource;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public boolean isGroup() {
        return this.groupType != -1;
    }

    public boolean isNumeric() {
        return this.dataType == 1001 || this.dataType == 1010 || this.dataType == 1006 || this.dataType == 1005 || this.dataType == 1007;
    }

    public boolean isString() {
        return this.dataType == 1002 || this.dataType == 1011 || this.dataType == 1012;
    }

    public Integer getGroupType() {
        return this.groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public Integer getSplitType() {
        return this.splitType;
    }

    public void setSplitType(Integer splitType) {
        this.splitType = splitType;
    }

    public void setAutoGen(Boolean autoGen) {
        this.autoGen = autoGen;
    }

    @Override
    public boolean isAutoGen() {
        return this.autoGen;
    }

    public void setAccessControl(Boolean accessControl) {
        this.accessControl = accessControl;
    }

    public Boolean isAccessControl() {
        return this.accessControl;
    }

    public Boolean isSystemControlField() {
        return this.systemControlField;
    }

    public void setSystemControlField(Boolean systemControlField) {
        this.systemControlField = systemControlField;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSort() {
        return this.sort;
    }

    public Boolean isIgnoreSave() {
        return this.ignoreSave;
    }

    public void setIgnoreSave(Boolean ignoreSave) {
        this.ignoreSave = ignoreSave;
    }

    public Boolean isIgnoreQuery() {
        return this.ignoreQuery;
    }

    public void setIgnoreQuery(Boolean ignoreQuery) {
        this.ignoreQuery = ignoreQuery;
    }

    public Boolean isIgnoreModify() {
        return this.ignoreModify;
    }

    public void ignoreModify(Boolean ignore) {
        this.ignoreModify = ignore;
    }

    public void setPeriodGranularity(Integer periodGranularity) {
        this.periodGranularity = periodGranularity;
    }

    public Integer getPeriodGranularity() {
        return this.periodGranularity;
    }

    public Boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(Boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public String getPeriodImpl() {
        return this.periodImpl;
    }

    public void setPeriodImpl(String periodImpl) {
        this.periodImpl = periodImpl;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public String getCodeColumnKey() {
        return this.codeColumnKey;
    }

    public void setCodeColumnKey(String codeColumnKey) {
        this.codeColumnKey = codeColumnKey;
    }

    public String getDataElementKey() {
        return this.dataElementKey;
    }

    public void setDataElementKey(String dataElementKey) {
        this.dataElementKey = dataElementKey;
    }

    public void setDataElement(MetaDataElement dataElement) {
        this.dataElement = dataElement;
    }

    public MetaDataElement getDataElement() {
        return this.dataElement;
    }

    public void setRefCol(String refCol) {
        this.refCol = refCol;
    }

    public String getRefCol() {
        return this.refCol;
    }

    public void setRefItemKeyCol(String itemKeyCol) {
        this.refItemKeyCol = itemKeyCol;
    }

    public String getRefItemKeyCol() {
        return this.refItemKeyCol;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaColumn newObject = new MetaColumn();
        newObject.setKey(this.key);
        newObject.setCaption(this.caption);
        newObject.setDefaultValue(this.defaultValue);
        newObject.setDefaultFormulaValue(this.defaultFormulaValue);
        newObject.setDescription(this.description);
        newObject.setPersist(this.persist);
        newObject.setDBColumnName(this.dbColumnName);
        newObject.setDataType(this.dataType);
        newObject.setLength(this.length);
        newObject.setPrecision(this.precision);
        newObject.setScale(this.scale);
        newObject.setIsPrimary(this.isPrimary);
        newObject.setCache(this.cache);
        newObject.setNeedRights(this.needRights);
        newObject.setItemKey(this.itemKey);
        newObject.setExpand(this.isExpand);
        newObject.setExpandSource(this.expandSource == null ? null : (MetaBaseScript)this.expandSource.clone());
        newObject.setHidden(this.hidden);
        newObject.setGroupType(this.groupType);
        newObject.setSplitType(this.splitType);
        newObject.setAutoGen(this.autoGen);
        newObject.setAccessControl(this.accessControl);
        newObject.setSort(this.sort);
        newObject.setIgnoreSave(this.ignoreSave);
        newObject.setIgnoreQuery(this.ignoreQuery);
        newObject.ignoreModify(this.ignoreModify);
        newObject.setPeriodGranularity(this.periodGranularity);
        newObject.setUserTag(this.userTag);
        newObject.setCodeColumnKey(this.codeColumnKey);
        newObject.setSupportI18n(this.supportI18n);
        newObject.setDataElementKey(this.dataElementKey);
        newObject.setDataElement(this.dataElement);
        newObject.setRefCol(this.refCol);
        newObject.setRefItemKeyCol(this.refItemKeyCol);
        newObject.setPrimaryKey(this.isPrimaryKey);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaColumn();
    }

    public void setSupportI18n(Boolean i18n) {
        this.supportI18n = i18n;
    }

    public Boolean isSupportI18n() {
        return this.supportI18n;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        if (this.dataElementKey == null || this.dataElementKey.isEmpty()) {
            return;
        }
        try {
            if (this.dataElement != null) {
                return;
            }
            if (callback != null) {
                try {
                    callback.call((Object)this);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.dataElement != null) {
                this.checkValid();
                MetaAnnotationUtil.mergeProperty((Object)this, this.dataElement);
            }
        }
        catch (Throwable e) {
            throw new MetaException(4217, SimpleStringFormat.format((String)StringTable.getString(null, "", "MetaLoadError"), (Object[])new Object[]{TAG_NAME, this.key}), e);
        }
    }

    private void checkValid() {
        if (this.dataElementKey == null || this.dataElementKey.isEmpty()) {
            return;
        }
        if (this.dataType != null && this.dataType > 0) {
            throw new MetaException(4216, SimpleStringFormat.format((String)StringTable.getString(null, "", "AttributeConflict"), (Object[])new Object[]{"DataElementKey", "DataType"}));
        }
        if (this.length != null && this.length > 0) {
            throw new MetaException(4216, SimpleStringFormat.format((String)StringTable.getString(null, "", "AttributeConflict"), (Object[])new Object[]{"DataElementKey", "Length"}));
        }
        if (this.precision != null && this.precision > 0) {
            throw new MetaException(4216, SimpleStringFormat.format((String)StringTable.getString(null, "", "AttributeConflict"), (Object[])new Object[]{"DataElementKey", "Precision"}));
        }
        if (this.scale != null && this.scale > 0) {
            throw new MetaException(4216, SimpleStringFormat.format((String)StringTable.getString(null, "", "AttributeConflict"), (Object[])new Object[]{"DataElementKey", "Scale"}));
        }
    }

    public boolean isCaseSensitive() {
        MetaDataElement dataElement = this.getDataElement();
        MetaDomain domain = dataElement == null ? null : dataElement.getDomain();
        return domain != null && Boolean.TRUE.equals(domain.isCaseSensitive());
    }
}

