/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.ex.TextSyntaxException;
import com.bokesoft.yes.meta.persist.dom.xml.parse.CharUtil;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Entry;

public class TextAnalyzer {
    private static TextAnalyzer sington = new TextAnalyzer();

    public static TextAnalyzer New() {
        return sington;
    }

    public Entry getBlank(String source, int bg) {
        int ed = source.length();
        for (int i = bg; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (CharUtil.isBlank(c)) continue;
            ed = i;
            break;
        }
        if (ed <= bg) {
            return null;
        }
        Entry e = new Entry();
        e.setType(2);
        e.setBg(bg);
        e.setEd(ed - 1);
        return e;
    }

    public Entry getString(String source, int bg, char[] borderChar, char[] escape, boolean useLRLN) {
        boolean isStart = false;
        Entry entry = null;
        char useBorder = '\"';
        for (int i = bg; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!isStart) {
                if (CharUtil.isBlank(c)) continue;
                if (CharUtil.isInIt(c, borderChar)) {
                    isStart = true;
                    useBorder = c;
                    entry = new Entry();
                    entry.setType(1);
                    entry.setBg(i);
                    continue;
                }
                return null;
            }
            if (c == useBorder) {
                if (i == source.length() - 1) {
                    entry.setEd(i);
                    break;
                }
                if (CharUtil.isInIt(c, escape)) {
                    if (source.charAt(i + 1) == c) {
                        ++i;
                        continue;
                    }
                    entry.setEd(i);
                    break;
                }
                entry.setEd(i);
                break;
            }
            if (CharUtil.isInIt(c, escape)) {
                ++i;
                continue;
            }
            if (c != '\r' && c != '\n' || useLRLN) continue;
            throw new TextSyntaxException("\u5b57\u7b26\u4e32\u4e0d\u80fd\u6362\u884c[\\r\\n]\r\n[" + source.substring(bg, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n" + source.substring(i) + "]");
        }
        if (entry == null) {
            return null;
        }
        if (entry.getEd() == -1) {
            throw new TextSyntaxException("\u5b57\u7b26\u4e32\u6ca1\u6709\u6b63\u5e38\u7684\u7ed3\u675f[\\r\\n]\r\n[" + source.substring(entry.getBg()) + "]");
        }
        return entry;
    }

    public Entry getCommonString(String source, int bg) {
        return this.getString(source, bg, new char[]{'\"'}, new char[]{'\\'}, false);
    }

    public Entry getXmlString(String source, int bg) {
        return this.getString(source, bg, new char[]{'\"', '\''}, null, true);
    }

    public Entry getSqlString(String source, int bg) {
        return this.getString(source, bg, new char[]{'\''}, new char[]{'\\', '\''}, false);
    }

    public Entry getName(String source, int bg, char[] wordChars, char[] endChars) {
        boolean isStart = false;
        Entry entry = new Entry();
        entry.setType(3);
        for (int i = bg; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!isStart) {
                if (CharUtil.isBlank(c)) continue;
                if (CharUtil.isNameStartChar(c)) {
                    isStart = true;
                    entry.setBg(i);
                    continue;
                }
                return null;
            }
            if (CharUtil.isNameChar(c) || CharUtil.isInIt(c, wordChars)) continue;
            if (CharUtil.isBlank(c) || CharUtil.isInIt(c, endChars)) {
                entry.setEd(i - 1);
                break;
            }
            throw new TextSyntaxException("\u5143\u7d20\u540d\u79f0\uff0c\u4e0d\u80fd\u542b\u6709\u5b57\u7b26[" + c + "]\r\n[" + source.substring(bg, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n" + source.substring(i) + "]");
        }
        if (entry.getBg() == -1) {
            return null;
        }
        if (entry.getEd() == -1) {
            entry.setEd(source.length() - 1);
        }
        return entry;
    }

    public Entry getComment(String source, int bg, String bgStr, String endStr) {
        boolean isStart = false;
        Entry entry = new Entry();
        entry.setType(4);
        for (int i = bg; i < source.length(); ++i) {
            if (!isStart) {
                if (!StringUtil.isString((String)source, (String)bgStr, (int)i)) continue;
                isStart = true;
                entry.setBg(i);
                i += bgStr.length() - 1;
                continue;
            }
            if (!StringUtil.isString((String)source, (String)endStr, (int)i)) continue;
            entry.setEd(i + (endStr.length() - 1));
            break;
        }
        if (entry.getBg() == -1) {
            return null;
        }
        if (entry.getEd() == -1) {
            throw new TextSyntaxException("Comment\u5143\u7d20\u6ca1\u6709\u7ed3\u5c3e\r\n[" + source.substring(entry.getBg()) + "]");
        }
        return entry;
    }
}

