package com.bokesoft.yigo.meta.timer.action;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class TimerWorkitemCommit extends MetaAbstractAction {

	public static final String TAG_NAME = "TimerWorkitemCommit";

	private String participatorFormula;

	private Integer result = -1;

	private String userInfo;

	@Override
	public int getType() {
		return WorkitemCommit;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new TimerWorkitemCommit();
	}

	public String getParticipatorFormula() {
		return participatorFormula;
	}

	public void setParticipatorFormula(String participatorFormula) {
		this.participatorFormula = participatorFormula;
	}

	public Integer getResult() {
		return result;
	}

	public void setResult(Integer result) {
		this.result = result;
	}

	public String getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}

	@Override
	public AbstractMetaObject clone() {
		TimerWorkitemCommit newTimerWorkitemCommit = (TimerWorkitemCommit) newInstance();
		newTimerWorkitemCommit.setParticipatorFormula(participatorFormula);
		newTimerWorkitemCommit.setResult(result);
		newTimerWorkitemCommit.setUserInfo(userInfo);
		return newTimerWorkitemCommit;
	}

}
