package com.bokesoft.yigo.meta.timer;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.timer.action.MetaAbstractAction;
import com.bokesoft.yigo.meta.timer.action.TimerMidFormula;
import com.bokesoft.yigo.meta.timer.action.TimerSeDevClass;
import com.bokesoft.yigo.meta.timer.action.TimerWorkitemCommit;
import com.bokesoft.yigo.meta.timer.period.Moment;
import com.bokesoft.yigo.meta.timer.period.Period;
import com.bokesoft.yigo.meta.timer.period.WorkDay;

/**
 * 定时任务
 * 
 * @author 刘翔翔
 *
 */
public class MetaTimerTask extends AbstractMetaObject {

	public static final String TAG_NAME = "TimerTask";

	/** 时间间隔 */
	private Period period;

	/** 定时行为 */
	private MetaAbstractAction timerAction;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(period);
		list.add(timerAction);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(TimerMidFormula.TAG_NAME)) {
			timerAction = new TimerMidFormula();
			child = timerAction;
		} else if (tagName.equalsIgnoreCase(TimerSeDevClass.TAG_NAME)) {
			timerAction = new TimerSeDevClass();
			child = timerAction;
		} else if (tagName.equalsIgnoreCase(TimerWorkitemCommit.TAG_NAME)) {
			timerAction = new TimerWorkitemCommit();
			child = timerAction;
		} else if (tagName.equalsIgnoreCase(Moment.TAG_NAME)) {
			period = new Moment();
			child = period;
		} else if (tagName.equalsIgnoreCase(WorkDay.TAG_NAME)) {
			period = new WorkDay();
			child = period;
		}

		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTimerTask newTimerTask = (MetaTimerTask) newInstance();
		newTimerTask.setPeriod(period == null ? null : (Period) period.clone());
		newTimerTask.setTimerAction(timerAction == null ? null : (MetaAbstractAction) timerAction.clone());
		return newTimerTask;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimerTask();
	}

	public Period getPeriod() {
		return period;
	}

	public MetaAbstractAction getTimerAction() {
		return timerAction;
	}

	public void setPeriod(Period period) {
		this.period = period;
	}

	public void setTimerAction(MetaAbstractAction timerAction) {
		this.timerAction = timerAction;
	}

}
