package com.bokesoft.yigo.meta.taskflow.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 任务流程中的节点
 */
public abstract class MetaNode extends KeyPairMetaObject {
	/** 唯一标识 */
	protected String key = null;
	/** 名称 */
	protected String caption = null;
	/** 样式 */
	private MetaStyle style = null;
	/** 输入参数 */
	private MetaInputParas inputParas = null;
	/** 连线集合*/
	private MetaSequenceFlows sequenceFlows = null;
	
	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 获取样式
	 * @return 样式
	 */
	public MetaStyle getStyle() {
		return this.style;
	}
	
	/**
	 * 设置样式
	 * @param style 样式
	 */
	public void setStyle(MetaStyle style) {
		this.style = style;
	}
	
	/**
	 * 获取输入参数
	 * @return 输入参数
	 */
	public MetaInputParas getInputParas() {
		return this.inputParas;
	}
	
	/**
	 * 设置输入参数
	 * @param meta 输入参数
	 */
	public void setInputParas(MetaInputParas meta) {
		this.inputParas = meta;
	}
	/**
	 * 获取连线集合
	 * @return 连线集合
	 */
	public MetaSequenceFlows getSequenceFlows() {
		return this.sequenceFlows;
	}
	
	/**
	 * 设置连线集合
	 * @param meta 连线集合
	 */
	public void setSequenceFlows(MetaSequenceFlows meta) {
		this.sequenceFlows = meta;
	}
	
	public abstract int getNodeType();
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(tagName.equals(MetaStyle.TAG_NAME)) {
			this.style = new MetaStyle();
			resultMetaObject = this.style;
		}else if(tagName.equals(MetaInputParas.TAG_NAME)) {
			this.inputParas = new MetaInputParas();
			resultMetaObject = this.inputParas;
		}else if(tagName.equals(MetaSequenceFlows.TAG_NAME)) {
			this.sequenceFlows = new MetaSequenceFlows();
			resultMetaObject = this.sequenceFlows;
		}
		
		return resultMetaObject;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {style, inputParas, sequenceFlows});
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaNode clone = (MetaNode) this.newInstance();
		clone.setKey(key);
		clone.setCaption(caption);
		clone.setStyle(style == null ? null : (MetaStyle)style.clone());
		clone.setInputParas(inputParas == null ? null : (MetaInputParas)inputParas.clone());
		clone.setSequenceFlows(sequenceFlows == null ? null : (MetaSequenceFlows)sequenceFlows.clone());
		return clone;
	}

}
