package com.bokesoft.yigo.meta.task.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;
import com.bokesoft.yigo.meta.task.data.MetaTaskDataInput;
import com.bokesoft.yigo.meta.task.transition.MetaTaskTransitionCollection;

public abstract class MetaTaskNode extends AbstractBPMElement {
	
	protected MetaTaskDataInput dataInput  = null;
	
	protected MetaTaskTransitionCollection transitionCollection = null;
	
	public MetaTaskDataInput getDataInput() {
		return dataInput;
	}

	public void setDataInput(MetaTaskDataInput dataInput) {
		this.dataInput = dataInput;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {dataInput});
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaTaskDataInput.TAG_NAME.equals(tagName)) {
			dataInput = new MetaTaskDataInput();
			child = dataInput;
		}else if (MetaTaskTransitionCollection.TAG_NAME.equals(tagName)) {
			transitionCollection = new MetaTaskTransitionCollection();
			child = transitionCollection;
		}
		return child;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTaskNode obj = (MetaTaskNode) super.clone();
		obj.dataInput = dataInput == null ? null : (MetaTaskDataInput)dataInput.clone();
		obj.transitionCollection = transitionCollection == null ? null : (MetaTaskTransitionCollection)transitionCollection.clone();
		return obj;
	}

	public abstract int getNodeType();
	
}
