package com.bokesoft.yigo.meta.task.deploy;

import java.util.LinkedList;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.task.MetaTaskProcessProfile;

public class MetaTask extends AbstractMetaObject {
	public static final String TAG_NAME = "Task";
	
	private String initDate = DateUtil.getDateFormatText(null, "yyyy.MM.dd HH:mm:ss z");
	
	private MetaTaskProcessDeployInfoCollection deployInfoCollection = new MetaTaskProcessDeployInfoCollection();
	
	private StringHashMap<MetaTaskProcessProfile> profileMap = new StringHashMap<MetaTaskProcessProfile>();
	
	public String getInitDate() {
		return initDate;
	}

	public void setInitDate(String initDate) {
		this.initDate = initDate;
	}

	public MetaTaskProcessDeployInfoCollection getDeployInfoCollection() {
		return deployInfoCollection;
	}

	public void setDeployInfoCollection(MetaTaskProcessDeployInfoCollection deployInfoCollection) {
		this.deployInfoCollection = deployInfoCollection;
	}

	public StringHashMap<MetaTaskProcessProfile> getProfileMap() {
		return profileMap;
	}

	public void setProfileMap(StringHashMap<MetaTaskProcessProfile> profileMap) {
		this.profileMap = profileMap;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {deployInfoCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaTaskProcessDeployInfoCollection.TAG_NAME.equals(tagName)) {
			deployInfoCollection = new MetaTaskProcessDeployInfoCollection();
			child = deployInfoCollection;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTask obj = (MetaTask) newInstance();
		obj.initDate = initDate;
		obj.deployInfoCollection = deployInfoCollection== null ? null : (MetaTaskProcessDeployInfoCollection)deployInfoCollection.clone();
		return obj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTask();
	}

}
