package com.bokesoft.yigo.meta.setting;

import java.util.HashMap;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaSimpleSetting定义[名－值]形式的配置，目的是不需要为每一个简单配置都定义一个配置对象
 * @author wangyh
 *
 */
public class MetaSimpleSetting extends AbstractMetaObject {
	private String tagName = "";
	private HashMap<String, String> properties = null;
	public MetaSimpleSetting(String tagName) {
		this.tagName = tagName;
		this.properties = new HashMap<String, String>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return tagName;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 取得属性集
	 * @return 属性集
	 */
	public HashMap<String, String> getProperties() {
		return this.properties;
	}
	
	/**
	 * 增加属性值
	 * @param key 标识
	 * @param value 值
	 */
	public void put(String key, String value) {
		this.properties.put(key, value);
	}
	
	/**
	 * 取得属性值
	 * @param key 标识
	 * @return 值
	 */
	public String get(String key) {
		return properties.get(key);
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSimpleSetting newObject = (MetaSimpleSetting)newInstance();
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSimpleSetting(this.tagName);
	}
	
}
