package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMigrationSetting extends AbstractMetaObject {

	public static final String TAG_NAME = "MigrationSetting";

	/** 是否使用优化算法提高迁移速度 */
	private Boolean useOptimization = true;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMigrationSetting clone = new MetaMigrationSetting();
		clone.setUseOptimization(useOptimization);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMigrationSetting();
	}

	public Boolean isUseOptimization() {
		return useOptimization;
	}

	public void setUseOptimization(Boolean useOptimization) {
		this.useOptimization = useOptimization;
	}

}
