package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaAttachmentService extends GenericKeyCollection<MetaAttachmentProvider> {
	/** 默认附件提供者的标识 */
	private String defaultProvider = "";
	/** 上传文件的大小,-1表示无限制 */
	private Integer maxSize = -1;
	/** 允许的类型*/
	private String allowedTypes ="";
	
	public MetaAttachmentService() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "AttachmentService";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置默认附件提供者的标识
	 * @param defaultProvider 附件提供者标识 
	 */
	public void setDefaultProvider(String defaultProvider) {
		this.defaultProvider = defaultProvider;
	}
	
	/**
	 * 取得默认附件提供者的标识
	 * @return 附件提供者标识
	 */
	public String getDefaultProvider() {
		return this.defaultProvider;
	}
	

	/** 
	 * 取得上传文件的大小，-1表示无限制
	 * @return 文件大小
	 * */
	public Integer getMaxSize() {
		return maxSize;
	}

	
	/** 
	 * 设置上传文件的大小， -1表示无限制
	 * @param maxSize 文件大小
	 * */
	public void setMaxSize(Integer maxSize) {
		this.maxSize = maxSize;
	}
	
	/**
	 * 取得允许的文件类型
	 * @return 允许的文件类型
	 */
	public String getAllowedTypes() {
		return allowedTypes;
	}

	/**
	 * 设置允许的文件类型
	 * @param allowedTypes 允许的文件类型
	 */
	public void setAllowedTypes(String allowedTypes) {
		this.allowedTypes = allowedTypes;
	}


	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaAttachmentProvider.TAG_NAME.equals(tagName) ) {
			MetaAttachmentProvider provider = new MetaAttachmentProvider();
			provider.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(provider);
			resultMetaObject = provider;
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaAttachmentService newObject = (MetaAttachmentService)newInstance();
		newObject.setDefaultProvider(defaultProvider);
		newObject.setMaxSize(maxSize);
		newObject.setAllowedTypes(allowedTypes);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaAttachmentService();
	}

}
