package com.bokesoft.yigo.meta.schema;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据表的列属性类
 * 
 * @author 曹晶晶
 *
 */
public class MetaSchemaColumn extends KeyPairMetaObject {

	/** 列的标签名 */
	public static final String TAG_NAME = "Column";

	/** 列的标识，整个Table中不可以重复 */
	private String key = "";

	/** 字段的名称 */
	private String caption = "";

	/**
	 * 列的数据类型，取值
	 * 
	 * @see com.bokesoft.yigo.common.def.DataType
	 */
	private int dataType = -1;

	/** 长度，在DataType取值为Varchar时，取值为字符串的长度；DataType取值为Binary时为最大字节数 */
	private int length = 0;

	/** 数值精度。在DataType取值为Numeric时表示数值的精度 */
	private int precision = 0;

	/** 小数位精度，在DataType取值为Numeric的时候，取值为数值的小数位长度 */
	private int scale = 0;

	/** 是否为表的主键字段 */
	private boolean isPK = false;
	
	/** 是否为表的分区字段 */
	private boolean isPartition=false;
	
	private boolean isAutoGen=false;

	/** 字段默认值 */
	private String defaultValue = "";

	/** 是否大小写敏感  */
	private boolean caseSensitive = false;

	public MetaSchemaColumn() {
	}
	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public int getDataType() {
		return dataType;
	}

	public void setDataType(int dataType) {
		this.dataType = dataType;
	}

	public int getLength() {
		return length;
	}

	public void setLength(int length) {
		this.length = length;
	}

	public void setLength(Integer length) {
		if(length != null) {
			this.length = length;
		}
	}
	
	public int getPrecision() {
		return precision;
	}

	public void setPrecision(int precision) {
		this.precision = precision;
	}

	public void setPrecision(Integer precision) {
		if(precision != null) {
			this.precision = precision;
		}
	}
	
	public int getScale() {
		return scale;
	}

	public void setScale(int scale) {
		this.scale = scale;
	}

	public void setScale(Integer scale) {
		if(scale != null) {
			this.scale = scale;
		}
	}
	
	public boolean isPK() {
		return isPK;
	}

	public void setPK(boolean isPK) {
		this.isPK = isPK;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSchemaColumn newObject = new MetaSchemaColumn();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDataType(dataType);
		newObject.setLength(length);
		newObject.setPrecision(precision);
		newObject.setScale(scale);
		newObject.setPK(isPK);
		newObject.setPartition(isPartition);
		newObject.setDefaultValue(defaultValue);
		newObject.setCaseSensitive(caseSensitive);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSchemaColumn();
	}

	public boolean isPartition() {
		return isPartition;
	}

	public void setPartition(boolean isPartition) {
		this.isPartition = isPartition;
	}

	@Override
	public boolean isAutoGen() {
		return isAutoGen;
	}

	public void setAutoGen(boolean isAutoGen) {
		this.isAutoGen = isAutoGen;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public boolean isCaseSensitive() {
		return caseSensitive;
	}
	public void setCaseSensitive(boolean caseSensitive) {
		this.caseSensitive = caseSensitive;
	}
}
