package com.bokesoft.yigo.meta.rights;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDictRightsCollection extends GenericNoKeyCollection<MetaDictDefinition> implements IElementMerge<MetaDictRightsCollection>{
	
	public static final String TAG_NAME = "DictRightsCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resutMetaObject = null;
		if( MetaDictDefinition.TAG_NAME.equals(tagName) ) {
			MetaDictDefinition dictDefinition = new MetaDictDefinition();
			this.add(dictDefinition);
			resutMetaObject = dictDefinition;
		}
		return resutMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictRightsCollection();
	}
	
	/**
	 * 是否包含给定的字典定义
	 * @param itemKey 字典标识
	 * @return 如果itemKey的权限定义存在则返回true，否则返回false
	 */
	public boolean contains(String itemKey) {
		for( MetaDictDefinition dictDefinition : this ) {
			if( dictDefinition.getItemKey().equals(itemKey) ) {
				return true;
			}
		}
		return false;
	}

	@Override
	public MetaDictRightsCollection toMerge(MetaDictRightsCollection obj) {
		if (obj != null) {
			Iterator<MetaDictDefinition> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDictDefinition metaDictDefinition = (MetaDictDefinition) iterator.next();
				add(metaDictDefinition);
			}
		}
		return this;
	}

}
