package com.bokesoft.yigo.meta.report.embed;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportImage extends MetaReportEmbedObject {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 图片路径：来源于resource */
	private String path = "";
	/** 图片缩放显示方式  */
	private int imageScaleType = ImageScaleType.FIT_XY;
	
	public MetaReportImage() {
		super();
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	
	/**
	 * 设置图片路径
	 * @param path 图片路径
	 */
	public void setPath(String path) {
		this.path = path;
	}
	
	
	/**
	 * 获取图片路径
	 * @return 图片路径
	 */
	public String getPath() {
		return path;
	}
	
	
	/**
	 * 设置图片伸缩类型
	 * @param imageScaleType 图片伸缩类型
	 */
	public void setImageScaleType(int imageScaleType) {
		this.imageScaleType = imageScaleType;
	}
	
	
	/**
	 * 获取图片伸缩类型
	 * @return 图片伸缩类型
	 */
	public int getImageScaleType() {
		return this.imageScaleType;
	}
	
	@Override
	public int getCompositeType() {
		return ReportEmbedType.Image;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Image";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportImage newImage = new MetaReportImage();
		newImage.setX(super.getX());
		newImage.setY(super.getY());
		newImage.setWidth(super.getWidth());
		newImage.setHeight(super.getHeight());
		
		newImage.setKey(key);
		newImage.setCaption(caption);
		newImage.setPath(path);
		newImage.setImageScaleType(imageScaleType);
		return newImage;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportImage();
	}

}
