package com.bokesoft.yigo.meta.report;

/**
 * ReportCellSortType定义报表单元格的排序类型
 * @author wangyh
 *
 */
public class ReportCellSortType {
	/** 无排序 */
	public static final int None = 0;
	/** 无排序字符串表示 */
	public static final String STR_None = "None";
	
	/** 升序 */
	public static final int Asc = 1;
	/** 升序字符串表示 */
	public static final String STR_Asc = "Asc";
	
	/** 降序 */
	public static final int Desc = 2;
	/** 降序字符串表示 */
	public static final String STR_Desc = "Desc";
	
	/**
	 * 根据字符串解析排序类型标识
	 * @param s 排序类型的字符串表示，取值范围为
	 * <ul>
	 * <li>{@link #STR_None}
	 * <li>{@link #STR_Asc}
	 * <li>{@link #STR_Desc}
	 * </ul>
	 * @return 如果s的取值在定义的范围内，返回相应的排序标识，否则返回-1
	 */
	public static int parse(String s) {
		int sortType = -1;
		if ( STR_None.equalsIgnoreCase(s) ) {
			sortType = None;
		} else if ( STR_Asc.equalsIgnoreCase(s) ) {
			sortType = Asc;
		} else if ( STR_Desc.equalsIgnoreCase(s) ) {
			sortType = Desc;
		}
		
		return sortType;
	}
	
	/**
	 * 根据排序类型返回其字符串表示
	 * @param type 排序类型，取值范围为
	 * <ul>
	 * <li>{@link #None}
	 * <li>{@link #Asc}
	 * <li>{@link #Desc}
	 * </ul>
	 * @return 如果type在取值范围内，返回相应的字符串，否则返回空字符串
	 */
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch ( type ) {
		case None:
			s = STR_None;
			break;
		case Asc:
			s = STR_Asc;
			break;
		case Desc:
			s = STR_Desc;
			break;
		}
		return s;
	}
}
