package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ContentOverflowType;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.report.embed.MetaReportChart;

public class MetaReportGridCell extends AbstractMetaObject {
	public static final String TAG_NAME = "Cell";
	
	/** 单元格的标识，定义的目的主要是在表达式中使用 */
	private String key = "";
	/** 单元格的名称，在数据源属性无定义的情况下，为单元格的文本内容 */
	private String caption = "";
	/** 文本内容 */
	private MetaReportCellText text = null;
	/** 单元格类型 */
	private Integer contentType = ReportCellContentType.Text;
	/** 数据来源类型 */
	private Integer sourceType = -1;
	/** 绑定的数据表标识 */
	private String tableKey = "";
	/** 绑定的数据字段标识,sourceType为字段时，定义为数据列标识 */
	private String fieldKey = "";
	/** 表达式，sourceType为表达式时，定义为表达式的内容 */
	private String formula = "";
	/** 接口实现类，sourceType为接口时，定义为实现类的全路径名 */
	private String impl = "";
	/** 页码定义 */
	private String pageNo = "";
	/** 单元格的分组类型 */
	private Integer groupType = ReportCellGroupType.None;
	/** 单元格的排序类型 */
	private Integer sortType = ReportCellSortType.None;
	/** 是否合并区域 */
	private Boolean isMerged = false;
	/** 是否合并区域头 */
	private Boolean isMergedHead = false;
	/** 合并行数量 */
	private Integer mergedRowSpan = 0;
	/** 合并列数量 */
	private Integer mergedColumnSpan = 0;
	/** 内边距 */
	private String padding = "";
	/** 内容溢出的处理方式 */
	private Integer overflow = ContentOverflowType.None;
	/** 是否合并明细区域 */
	private Boolean mergeDetail = false;
	/** 是否合并顶部分组汇总行 */
	private Boolean mergeTopGroup = false;
	/** 是否合并底部分组汇总行 */
	private Boolean mergeBottomGroup = false;
	/** 是否行扩展 */
	private Boolean isRowExpand = false;
	/** 是否列扩展 */
	private Boolean isColumnExpand = false;
	/** 行扩展 */
	private MetaReportRowExpand rowExpand = null;
	/** 行分组 */
	private MetaReportRowGroup rowGroup = null;
	/** 列扩展 */
	private MetaReportColumnExpand columnExpand = null;
	/** 显示相关属性 */
	private MetaReportDisplay display = null;
	/** 是否主键字段 */
	private Boolean isPrimary = false;
	/** 是否套打内容 */
	private Boolean fillEmptyContent = false;
	/** 图片文件来源类型 */
	private Integer imageSourceType = ImageSourceType.DATA;
	/** 图片路径，在来源为资源时定义 */
	private String path = "";
	/** 系统域定义 */
	private String systemContent = "";
	/** 总结信息标志，如果是true则需要在填充完之后再计算，否则立刻计算，只对表达式来源有效 */
	private Boolean isSummary = false;
	
	/** 图表定义 */
	private MetaReportChart metaChart = null;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaReportRowExpand.TAG_NAME.equals(tagName) ) {
			this.rowExpand = new MetaReportRowExpand();
			resultMetaObject = this.rowExpand;
		} else if ( MetaReportRowGroup.TAG_NAME.equals(tagName) ) {
			this.rowGroup = new MetaReportRowGroup();
			resultMetaObject = this.rowGroup;
		} else if ( MetaReportColumnExpand.TAG_NAME.equals(tagName) ) {
			this.columnExpand = new MetaReportColumnExpand();
			resultMetaObject = this.columnExpand;
		} else if ( MetaReportDisplay.TAG_NAME.equals(tagName) ) {
			this.display = new MetaReportDisplay();
			resultMetaObject = this.display;
		} else if ( MetaReportCellText.TAG_NAME.equals(tagName) ) {
			this.text = new MetaReportCellText();
			resultMetaObject = this.text;
		} else if ( MetaReportChart.TAG_NAME.equals(tagName) ) {
			this.metaChart = new MetaReportChart();
			resultMetaObject = this.metaChart;
		}
		return resultMetaObject;
	}

	/**
	 * 设置单元格标识
	 * @param key 单元格标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得单元格标识
	 * @return 单元格标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置单元格名称
	 * @param caption 单元格名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得单元格名称
	 * @return 单元格名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置单元格类型
	 * @param contentType 单元格类型
	 * @see ReportCellContentType
	 */
	public void setContentType(Integer contentType) {
		this.contentType = contentType;
	}
	
	/**
	 * 取得单元格类型
	 * @return 单元格类型
	 * @see ReportCellContentType
	 */
	public Integer getContentType() {
		return this.contentType;
	}
	
	/**
	 * 设置数据来源类型
	 * @param sourceType 数据来源类型
	 * @see ReportContentSourceType
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 取得数据来源类型
	 * @return 数据来源类型
	 * @see ReportContentSourceType
	 */
	public Integer getSourceType() {
		return this.sourceType;
	}
	
	/**
	 * 设置数据表标识
	 * @param tableKey 数据表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得数据表标识
	 * @return 数据表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置数据字段标识
	 * @param fieldKey 数据字段标识
	 */
	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}
	
	/**
	 * 取得数据字段标识
	 * @return 数据字段标识
	 */
	public String getFieldKey() {
		return this.fieldKey;
	}
	
	/**
	 * 设置表达式
	 * @param formula 表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public String getFormula() {
		return this.formula;
	}
	
	/**
	 * 设置接口实现类名
	 * @param impl 类名
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 取得接口实现类名
	 * @return 类名
	 */
	public String getImpl() {
		return this.impl;
	}
	
	/**
	 * 设置页码
	 * @param pageNo 页码
	 */
	public void setPageNo(String pageNo) {
		this.pageNo = pageNo;
	}
	
	/**
	 * 取得页码
	 * @return 页码
	 */
	public String getPageNo() {
		return this.pageNo;
	}
	
	/**
	 * 设置分组类型
	 * @param groupType 分组类型
	 */
	public void setGroupType(Integer groupType) {
		this.groupType = groupType;
	}
	
	/**
	 * 取得分组类型
	 * @return 分组类型
	 */
	public Integer getGroupType() {
		return this.groupType;
	}
	
	/**
	 * 设置排序类型
	 * @param sortType 排序类型
	 */
	public void setSortType(Integer sortType) {
		this.sortType = sortType;
	}
	
	/**
	 * 取得排序类型
	 * @return 排序类型
	 */
	public Integer getSortType() {
		return this.sortType;
	}
	
	/**
	 * 设置是否合并区域单元格
	 * @param isMerged 合并区域单元格标志
	 */
	public void setMerged(Boolean isMerged) {
		this.isMerged = isMerged;
	}
	
	/**
	 * 取得是否合并区域单元格
	 * @return 合并区域单元格标志
	 */
	public Boolean isMerged() {
		return this.isMerged;
	}
	
	/**
	 * 设置是否合并区域头
	 * @param isMergedHead 合并区域头标志
	 */
	public void setMergedHead(Boolean isMergedHead) {
		this.isMergedHead = isMergedHead;
	}
	
	/**
	 * 取得是否合并区域头
	 * @return 合并区域头标志
	 */
	public Boolean isMergedHead() {
		return this.isMergedHead;
	}
	
	/**
	 * 设置合并区域行跨度
	 * @param mergedRowSpan 合并区域行跨度
	 */
	public void setMergedRowSpan(Integer mergedRowSpan) {
		this.mergedRowSpan = mergedRowSpan;
	}
	
	/**
	 * 取得合并区域行跨度
	 * @return 合并区域行跨度
	 */
	public Integer getMergedRowSpan() {
		return this.mergedRowSpan;
	}
	
	/**
	 * 设置合并区域列跨度
	 * @param mergedColumnSpan 合并区域列跨度
	 */
	public void setMergedColumnSpan(Integer mergedColumnSpan) {
		this.mergedColumnSpan = mergedColumnSpan;
	}
	
	/**
	 * 取得合并区域列跨度
	 * @return 合并区域列跨度
	 */
	public Integer getMergedColumnSpan() {
		return this.mergedColumnSpan;
	}

	/**
	 * 取得内边距
	 * @return 内边距
	 */
	public String getPadding() {
		return padding;
	}

	/**
	 * 设置内边距
	 * @param padding 内边距
	 */
	public void setPadding(String padding) {
		this.padding = padding;
	}
	
	/**
	 * 设置内容溢出的处理方式
	 * @param overflow 内容溢出的处理方式
	 */
	public void setOverflow(Integer overflow) {
		this.overflow = overflow;
	}
	
	/**
	 * 取得内容溢出的处理方式
	 * @return 内容溢出的处理方式
	 */
	public Integer getOverflow() {
		return this.overflow;
	}
	
	/**
	 * 设置是否合并明细行
	 * @param mergeDetail 是否合并明细行标志
	 */
	public void setMergeDetail(Boolean mergeDetail) {
		this.mergeDetail = mergeDetail;
	}
	
	/**
	 * 取得是否合并明细行
	 * @return 是否合并明细行标志
	 */
	public Boolean isMergeDetail() {
		return this.mergeDetail;
	}
	
	/**
	 * 设置是否合并顶部分组行
	 * @param mergeTopGroup 是否合并顶部分组行标志
	 */
	public void setMergeTopGroup(Boolean mergeTopGroup) {
		this.mergeTopGroup = mergeTopGroup;
	}
	
	/**
	 * 取得是否合并顶部分组行
	 * @return 是否合并顶部分组行标志
	 */
	public Boolean isMergeTopGroup() {
		return this.mergeTopGroup;
	}
	
	/**
	 * 设置是否合并底部分组行
	 * @param mergeBottomGroup 是否合并底部分组行标志
	 */
	public void setMergeBottomGroup(Boolean mergeBottomGroup) {
		this.mergeBottomGroup = mergeBottomGroup;
	}
	
	/**
	 * 取得是否合并底部分组行
	 * @return 是否合并底部分组行标志
	 */
	public Boolean isMergeBottomGroup() {
		return this.mergeBottomGroup;
	}
	
	/**
	 * 设置行扩展
	 * @param rowExpand 行扩展
	 */
	public void setRowExpand(MetaReportRowExpand rowExpand) {
		this.rowExpand = rowExpand;
	}
	
	/**
	 * 取得行扩展
	 * @return 行扩展
	 */
	public MetaReportRowExpand getRowExpand() {
		return this.rowExpand;
	}
	
	/**
	 * 设置数据分组对象
	 * @param rowGroup 数据分组对象
	 */
	public void setRowGroup(MetaReportRowGroup rowGroup) {
		this.rowGroup = rowGroup;
	}
	
	/**
	 * 取得数据分组对象
	 * @return 数据分组对象
	 */
	public MetaReportRowGroup getRowGroup() {
		return this.rowGroup;
	}
	
	/**
	 * 设置列扩展
	 * @param columnExpand 列扩展
	 */
	public void setColumnExpand(MetaReportColumnExpand columnExpand) {
		this.columnExpand = columnExpand;
	}
	
	/**
	 * 取得列扩展
	 * @return 列扩展
	 */
	public MetaReportColumnExpand getColumnExpand() {
		return this.columnExpand;
	}
	
	/**
	 * 设置是否行扩展
	 * @param isRowExpand 是否行扩展
	 */
	public void setIsRowExpand(Boolean isRowExpand) {
		this.isRowExpand = isRowExpand;
	}
	
	/**
	 * 取得是否行扩展
	 * @return 是否行扩展
	 */
	public Boolean isRowExpand() {
		return this.isRowExpand;
	}
	
	/**
	 * 设置是否列扩展
	 * @param isColumnExpand 是否列扩展
	 */
	public void setIsColumnExpand(Boolean isColumnExpand) {
		this.isColumnExpand = isColumnExpand;
	}
	
	/**
	 * 取得是否列扩展
	 * @return 是否列扩展
	 */
	public Boolean isColumnExpand() {
		return this.isColumnExpand;
	}
	
	/**
	 * 设置是否主键
	 * @param isPrimary 是否主键
	 */
	public void setPrimary(Boolean isPrimary) {
		this.isPrimary = isPrimary;
	}
	
	/**
	 * 取得是否主键
	 * @return 是否主键
	 */
	public Boolean isPrimary() {
		return this.isPrimary;
	}
	
	/**
	 * 设置套打内容标志
	 * @param fillEmptyContent 套打内容标志
	 */
	public void setFillEmptyContent(Boolean fillEmptyContent) {
		this.fillEmptyContent = fillEmptyContent;
	}
	
	/**
	 * 取得套打内容标志
	 * @return 套打内容标志
	 */
	public Boolean isFillEmptyContent() {
		return this.fillEmptyContent;
	}
	
	/**
	 * 设置显示属性
	 * @param display 显示属性
	 */
	public void setDisplay(MetaReportDisplay display) {
		this.display = display;
	}
	
	/**
	 * 取得显示属性
	 * @return 显示属性
	 */
	public MetaReportDisplay getDisplay() {
		return this.display;
	}
	
	/**
	 * 取得显示属性，在为null的情况下创建一个空的
	 * @return 显示属性
	 */
	public MetaReportDisplay ensureDisplay() {
		if ( this.display == null ) {
			this.display = new MetaReportDisplay();
		}
		return this.display;
	}
	
	/**
	 * 设置图片来源类型
	 * @param imageSourceType 来源类型
	 */
	public void setImageSourceType(Integer imageSourceType) {
		this.imageSourceType = imageSourceType;
	}
	
	/**
	 * 取得图片来源类型
	 * @return 来源类型
	 */
	public Integer getImageSourceType() {
		return this.imageSourceType;
	}
	
	/**
	 * 设置图片路径
	 * @param path 路径
	 */
	public void setPath(String path) {
		this.path = path;
	}
	
	/**
	 * 取得图片路径
	 * @return 路径
	 */
	public String getPath() {
		return this.path;
	}
	
	/**
	 * 设置系统域定义
	 * @param systemContent 系统域定义
	 */
	public void setSystemContent(String systemContent) {
		this.systemContent = systemContent;
	}
	
	/**
	 * 取得系统域定义
	 * @return 系统域定义
	 */
	public String getSystemContent() {
		return this.systemContent;
	}
	
	/**
	 * 设置文本
	 * @param text 文本节点
	 */
	public void setTextNode(MetaReportCellText text) {
		this.text = text;
	}
	
	/**
	 * 取得文本节点
	 * @return 文本节点
	 */
	public MetaReportCellText getTextNode() {
		return this.text;
	}
	
	/**
	 * 取得文本内容
	 * @return 文本内容
	 */
	public String getText() {
		return text != null ? text.getContent() : this.caption; 
	}
	
	/**
	 * 设置总结信息标志
	 * @param isSummary 标志
	 */
	public void setSummary(Boolean isSummary) {
		this.isSummary = isSummary;
	}
	
	/**
	 * 取得总结信息标志
	 * @return 标志
	 */
	public Boolean isSummary() {
		return this.isSummary;
	}
	
	public void setChart(MetaReportChart metaChart) {
		this.metaChart = metaChart;
	}
	
	public MetaReportChart getChart() {
		return this.metaChart;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.rowExpand, this.columnExpand, this.rowGroup, 
				this.display, this.text, this.metaChart);
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportGridCell newCell = new MetaReportGridCell();
		newCell.setKey(key);
		newCell.setCaption(caption);
		newCell.setContentType(contentType);
		newCell.setSourceType(sourceType);
		newCell.setTableKey(tableKey);
		newCell.setFieldKey(fieldKey);
		newCell.setFormula(formula);
		newCell.setImpl(impl);
		newCell.setPageNo(pageNo);
		newCell.setGroupType(groupType);
		newCell.setSortType(sortType);
		newCell.setMerged(isMerged);
		newCell.setMergedHead(isMergedHead);
		newCell.setMergedRowSpan(mergedRowSpan);
		newCell.setMergedColumnSpan(mergedColumnSpan);
		newCell.setPadding(padding);
		newCell.setOverflow(overflow);
		newCell.setMergeDetail(mergeDetail);
		newCell.setMergeTopGroup(mergeTopGroup);
		newCell.setMergeBottomGroup(mergeBottomGroup);
		newCell.setIsRowExpand(isRowExpand);
		newCell.setIsColumnExpand(isColumnExpand);
		newCell.setRowExpand(rowExpand == null ? null : (MetaReportRowExpand) rowExpand.clone());
		newCell.setRowGroup(rowGroup == null ? null : (MetaReportRowGroup) rowGroup.clone());
		newCell.setColumnExpand(columnExpand == null ? null : (MetaReportColumnExpand) columnExpand.clone());
		newCell.setDisplay(display == null ? null : (MetaReportDisplay) display.clone());
		newCell.setPrimary(isPrimary);
		newCell.setFillEmptyContent(fillEmptyContent);
		newCell.setImageSourceType(imageSourceType);
		newCell.setPath(path);
		newCell.setSystemContent(systemContent);
		newCell.setTextNode(text == null ? null : (MetaReportCellText)text.clone());
		newCell.setSummary(isSummary);
		newCell.setChart(metaChart == null ? null : (MetaReportChart) metaChart.clone());
		return newCell;
		
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportGridCell();
	}

}
