package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ReportUnderLineStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaReportFont定义报表中的字体
 * @author wangyh
 *
 */
public class MetaReportFont extends AbstractMetaObject {
	/** 名称 */
	private String name = "";
	/** 大小 */
	private Integer size = 12;
	/** 是否粗体 */
	private Boolean bold = false;
	/** 是否斜体 */
	private Boolean italic = false;
	/** 下划线*/
	private Integer underlineStyle = ReportUnderLineStyle.None;
	
	public MetaReportFont() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Font";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置字体名称
	 * @param name 字体名称
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * 取得字体名称
	 * @return 字体名称
	 */
	public String getName() {
		return this.name;
	}
	
	/**
	 * 设置字体大小
	 * @param size 字体大小
	 */
	public void setSize(Integer size) {
		this.size = size;
	}
	
	/**
	 * 取得字体大小
	 * @return 字体大小
	 */
	public Integer getSize() {
		return this.size;
	}
	
	/**
	 * 设置是否粗体
	 * @param bold 粗体标志
	 */
	public void setBold(Boolean bold) {
		this.bold = bold;
	}
	
	/**
	 * 取得是否粗体
	 * @return 粗体标志
	 */
	public Boolean isBold() {
		return this.bold;
	}
	
	/**
	 * 设置是否斜体
	 * @param italic 斜体标志
	 */
	public void setItalic(Boolean italic) {
		this.italic = italic;
	}
	
	/**
	 * 取得是否斜体
	 * @return 斜体标志
	 */
	public Boolean isItalic() {
		return this.italic;
	}

	/**
	 * 获取下划线
	 * @return 下划线
	 */
	public Integer getUnderlineStyle() {
		return underlineStyle;
	}

	/**
	 * 设置下划线
	 * @param underlineStyle 下划线
	 */
	public void setUnderlineStyle(Integer underlineStyle) {
		this.underlineStyle = underlineStyle;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportFont newObject = (MetaReportFont)newInstance();
		newObject.setName(this.name);
		newObject.setSize(this.size);
		newObject.setBold(this.bold);
		newObject.setItalic(this.italic);
		newObject.setUnderlineStyle(this.underlineStyle);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportFont();
	}

}
