package com.bokesoft.yigo.meta.path.relation;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.common.def.PathTargetType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaRelationPart定义关系组成
 * @author wangyh
 *
 */
public class MetaRelationPart extends GenericKeyCollection<MetaRelationNodeB> {

	public static final String TAG_NAME = "Relation";
	
	/** 检查规则的KEY */
	private String key = "";
	/** 检查规则的中文描述 */
	private String caption = "";
	/** 节点的ID分配区间 */
	private Integer IDseed = -1;

	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 取得ID种子
	 * @return 种子
	 */
	public Integer getIDseed() {
		return IDseed;
	}

	/**
	 * 设置ID种子
	 * @param iDseed 种子
	 */
	public void setIDseed(Integer iDseed) {
		IDseed = iDseed;
	}

	/**
	 * 通过节点标识寻找node
	 * 
	 * @param key 标识
	 * @return node 节点
	 */
	public MetaRelationNodeB getNode(String key) {
		Iterator<MetaRelationNodeB> iterator = this.iterator();
		MetaRelationNodeB node = new MetaRelationNodeB();
		while (iterator.hasNext()) {
			node = iterator.next();
			if (node.getDataobjectkey().equals(key)) {
				return node;
			}
		}
		return null;
	}
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaRelationNodeB.TAG_NAME.equals(tagName)) {
			MetaRelationNodeB relationNode = new MetaRelationNodeB();
			relationNode.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(relationNode);
			resultMetaObject = relationNode;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationPart();
	}

}
