package com.bokesoft.yigo.meta.path;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaRelationProfile extends KeyPairMetaObject {

	/** key */
	private String key = null;
	/** 名称*/
	private String caption=null;
	/** 目标类型 */
	private int type = -1;
	/** 目标表单标识 */
	private String formkey = "";
	/** 目标对象标识 */
	private String targetkey = "";
	/** 资源路径 */
	private String resource = null;
	/** 关联的工程 */
	private IMetaProject project = null;
	/** 配置对象 */
	private MetaRelationPath relationPath = null;

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return this.key;
	}

	public void setResource(String resource) {
		this.resource = resource;
	}

	public String getResource() {
		return resource;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public String getFormkey() {
		return formkey;
	}

	public void setFormkey(String formkey) {
		if (formkey != null) {
			this.formkey = formkey;
		}
	}

	public String getTargetkey() {
		return targetkey;
	}

	public void setTargetkey(String targetkey) {
		this.targetkey = targetkey;
	}

	public void setProject(IMetaProject project) {
		this.project = project;
	}

	public IMetaProject getProject() {
		return project;
	}

	public void setRelationPath(MetaRelationPath relationPath) {
		this.relationPath = relationPath;
	}

	public MetaRelationPath getRelationPath() {
		return relationPath;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "Relation";

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaRelationProfile newObject = new MetaRelationProfile();
		newObject.setKey(key);
		newObject.setProject(project);
		newObject.setResource(resource);
		newObject.setRelationPath(relationPath);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaRelationProfile();
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

}
