package com.bokesoft.yigo.meta.path;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 节点
 *
 */
public class MetaRelationNode extends MetaRelationParentNode {

	private MetaRelationCollection lineCollection;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(lineCollection);
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaobject = null;
		if (MetaRelationCollection.TAG_NAME.equals(tagName)) {
			lineCollection = new MetaRelationCollection();
			resultMetaobject = lineCollection;
		}
		return resultMetaobject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationNode();
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	public MetaRelationCollection getLineCollection() {
		return lineCollection;
	}
	
	public void setLineCollection(MetaRelationCollection lineCollection) {
		this.lineCollection = lineCollection;
	}

}
