package com.bokesoft.yigo.meta.form.component.view;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaViewCollection extends GenericKeyCollection<MetaView> {
	public MetaViewCollection() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "ViewCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaView.TAG_NAME.equals(tagName)) {
			MetaView view = new MetaView();
			view.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(view);
			resultMetaObject = view;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaViewCollection();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaViewCollection newObject = (MetaViewCollection)super.clone();
		return newObject;
	}

	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaView view : this) {
			view.doPostProcess(flag, callback);
		}
	}
}