package com.bokesoft.yigo.meta.form.component.panel.gridpanel;
/*
 *文件名: MetaHandle
 *创建者: zhangk
 *创建时间:2022/9/10 15:14
 */

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

import java.util.LinkedList;

public class MetaHandle extends AbstractMetaObject implements Cloneable, IPropertyMerger<MetaHandle> {

	public static final String TAG_NAME = "Handle";
	Integer type = MetaHandleEnum.DEFAULT.getType();
	/**
	 * 组件处于父组件中的水平位置
	 */
	private Integer x = -1;

	/**
	 * 组件处于父组件中的垂直位置
	 */
	private Integer y = -1;

	/**
	 * 组件在网格面板中的水平跨度
	 */
	private Integer xSpan = 1;

	/**
	 * 组件在网格面板中的垂直跨度
	 */
	private Integer ySpan = 1;
	/**
	 * 展开样式
	 */
	private String expandStyleClass = "";
	/**
	 * 折叠样式
	 */
	private String collapseStyleClass = "";
	/** 格式 */
	protected MetaFormat format = null;
	public String getExpandStyleClass() {
		return expandStyleClass;
	}

	public void setExpandStyleClass(String expandStyleClass) {
		this.expandStyleClass = expandStyleClass;
	}

	public String getCollapseStyleClass() {
		return collapseStyleClass;
	}

	public void setCollapseStyleClass(String collapseStyleClass) {
		this.collapseStyleClass = collapseStyleClass;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getX() {
		return x;
	}

	public void setX(Integer x) {
		this.x = x;
	}

	public Integer getY() {
		return y;
	}

	public void setY(Integer y) {
		this.y = y;
	}

	public Integer getxSpan() {
		return xSpan;
	}

	public void setxSpan(Integer xSpan) {
		this.xSpan = xSpan;
	}

	public Integer getySpan() {
		return ySpan;
	}

	public void setySpan(Integer ySpan) {
		this.ySpan = ySpan;
	}
	public MetaFormat ensureFormat() {
		if( format == null ) {
			format = new MetaFormat();
		}
		return this.format;
	}

	public void setFormat(MetaFormat format) {
		this.format = format;
	}

	public MetaFormat getFormat() {
		return format;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(format);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaFormat.TAG_NAME)) {
			format = new MetaFormat();
			resultMetaObject = format;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaHandle newInstance = (MetaHandle) newInstance();
		newInstance.setxSpan(xSpan);
		newInstance.setySpan(ySpan);
		newInstance.setCollapseStyleClass(collapseStyleClass);
		newInstance.setExpandStyleClass(expandStyleClass);
		newInstance.setX(x);
		newInstance.setY(y);
		newInstance.setType(type);
		newInstance.setFormat(format);
		return newInstance;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHandle();
	}


	@Override
	public void merge(MetaHandle metaHandle) {

		if (this.type == null) {
			this.type = metaHandle.getType();
		}
		if (this.x == null) {
			this.x = metaHandle.getX();
		}
		if (this.y == null) {
			this.y = metaHandle.getY();
		}
		if (this.xSpan == null) {
			this.xSpan = metaHandle.getxSpan();
		}
		if (this.ySpan == null) {
			this.ySpan = metaHandle.getySpan();
		}
		if (this.expandStyleClass == null) {
			this.expandStyleClass = metaHandle.getExpandStyleClass();
		}
		if (this.collapseStyleClass == null) {
			this.collapseStyleClass = metaHandle.getCollapseStyleClass();
		}
		if (this.format == null) {
			this.format = metaHandle.getFormat();
		} else {
			this.format.merge(metaHandle.getFormat());
		}
	}
}
