package com.bokesoft.yigo.meta.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSize;

public class MetaSplitSizeAction extends BaseDomAction<MetaSplitSize> {
	@Override
	public void load(Document document, Element element, MetaSplitSize meta,
					 int runType) {
		DefSize size = DefSize.parse(DomHelper.readAttr(element, MetaConstants.SPLITPANEL_SIZE, ""));
		meta.setSize(size);
		meta.setForwardCollapased(DomHelper.readBool(element, MetaConstants.SPLITPANEL_FORWARD_COLLAPASED, false));
		meta.setReverseCollapased(DomHelper.readBool(element, MetaConstants.SPLITPANEL_REVERSE_COLLAPASED, false));
		meta.setType(MetaSplitSizeCollapaseTypeEnum.getTypeByName(DomHelper.readAttr(element, MetaConstants.SPLITPANEL_TYPE, "All")));
	}

	@Override
	public void save(Document document, Element element, MetaSplitSize meta,
					 int runType) {
		DefSize size = meta.getSize();
		if ( size != null ) {
			DomHelper.writeAttr(element, MetaConstants.SPLITPANEL_SIZE, size.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.SPLITPANEL_FORWARD_COLLAPASED, meta.getForwardCollapased(), false);
		DomHelper.writeAttr(element, MetaConstants.SPLITPANEL_REVERSE_COLLAPASED, meta.getReverseCollapased(), false);
		DomHelper.writeAttr(element, MetaConstants.SPLITPANEL_TYPE, MetaSplitSizeCollapaseTypeEnum.getNameByType(meta.getType()), "All");
	}

}
