package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaBorderLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutDirection;

public class MetaBorderLayoutPanel extends MetaPanel {
	public MetaBorderLayoutPanel() {
		super();
	}
	
	public static final String TAG_NAME = ControlType.STR_BORDERLAYOUTPANEL;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.BORDERLAYOUTPANEL;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBorderLayoutPanel();
	}

	/**
	 * 从边界布局面板中生成边界布局
	 * @return 边界布局
	 */
	@Override
	public MetaBorderLayout newLayout() {
		MetaBorderLayout layout = new MetaBorderLayout();
		layout.setKey(key);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutDirection item = new MetaLayoutDirection();
			item.setKey(metaComponent.getKey());
			item.setValue(metaComponent.getArea());
			layout.add(item);
		}
		return layout;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
