package com.bokesoft.yigo.meta.form.component.control.wizardlist;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.WizardItemListSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * 向导列表中单个导航项对应的选择列表
 */

public class MetaWizardItemList extends AbstractMetaObject {

	public static final String TAG_NAME = "WizardItemList";

	/**
	 * 层次界面的数据来源定义的表的标识。其指向的数据源表， 当{@link #getSourceType()}为
	 * {@link WizardItemListSourceType#Data}时，包含数据。 
	 */
	private String tableKey = "";
	/** 层次界面的数据来源，取值范围为{@link WizardItemListSourceType} */
	private Integer sourceType = WizardItemListSourceType.Data;
	/**
	 * 公式数据来源，仅{@link #getSourceType()}为{@link WizardItemListSourceType#Formula}
	 * 时有效
	 */
	private MetaBaseScript formulaItems;

	/**
	 * 获取层次界面的数据来源定义的表的标识
	 *
	 * @return 层次界面的数据来源定义的表的标识。 当{@link #getSourceType()}为
	 *         {@link WizardItemListSourceType#Data}时，包含数据。 当
	 *         {@link #getSourceType()}不为{@link WizardItemListSourceType#Data}时，
	 *         仅仅只是作为数据来源的表结构定义。默认值为{@link #tableKey}
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 * 设置获取层次界面的数据来源定义的表的标识
	 *
	 * @param tableKey 层次界面的数据来源定义的表的标识。 
	 * 当{@link #getSourceType()}为{@link WizardItemListSourceType#Data}时，包含数据。
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 获取层次界面的数据来源
	 *
	 * @return 层次界面的数据来源，取值范围为{@link WizardItemListSourceType}， 默认值为
	 *         {@link #sourceType}
	 */
	public Integer getSourceType() {
		return sourceType;
	}

	/**
	 * 设置层次界面的数据来源
	 *
	 * @param sourceType
	 *            层次界面的数据来源，取值范围为{@link WizardItemListSourceType}， 默认值为
	 *            {@link #sourceType}
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	/**
	 * 获取公式数据来源，仅{@link #getSourceType()}为
	 * {@link WizardItemListSourceType#Formula}时有效
	 *
	 * @return 公式数据来源
	 */
	public MetaBaseScript getFormulaItems() {
		return formulaItems;
	}

	/**
	 * 设置公式数据来源，仅{@link #getSourceType()}为
	 * {@link WizardItemListSourceType#Formula}时有效
	 *
	 * @param formulaItems
	 *            公式数据来源
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { formulaItems });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaConstants.COMBOBOX_FORMULAITEMS)) {
			this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
			resultMetaObject = formulaItems;
		}
		return resultMetaObject;
	}

	@Override
	public MetaWizardItemList clone() {
		MetaWizardItemList newObj = new MetaWizardItemList();
		newObj.setTableKey(tableKey);
		newObj.setSourceType(sourceType);
		newObj.setFormulaItems(formulaItems == null ? null : (MetaBaseScript) formulaItems.clone());
		return newObj;
	}

	@Override
	public MetaWizardItemList newInstance() {
		return new MetaWizardItemList();
	}
}
