package com.bokesoft.yigo.meta.form.component.control.treeview;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaTreeViewDataSource定义树状视图的数据来源，包括来源的类型和定义。
 * 来源的类型取值范围见{@link com.bokesoft.yigo.common.def.TreeDataSourceType}，根据类型的范围，来源的定义分别是字典的标识、
 * 表达式或者自定义内容(java代码或者js代码)
 * @author 王元和
 * @see com.bokesoft.yigo.common.def.TreeDataSourceType
 */
public class MetaTreeViewDataSource extends AbstractMetaObject {
	/** 数据来源的类型，取值范围见{@link com.bokesoft.yigo.common.def.TreeDataSourceType} */
	private Integer type = -1;
	/** 字典标识 */
	private String itemKey = "";
	/** 公式表示的字典标识 */
	private String formulaItemKey = "";
	
	public MetaTreeViewDataSource() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "TreeViewDataSource";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 设置数据来源类型
	 * @param type 树型结构数据来源类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得数据来源类型
	 * @return 树型结构数据来源类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}
	
	public String getItemKey() {
		return this.itemKey;
	}
	
	public void setFormulaItemKey(String formulaItemKey) {
		this.formulaItemKey = formulaItemKey;
	}
	
	public String getFormulaItemKey() {
		return this.formulaItemKey;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTreeViewDataSource newObject = new MetaTreeViewDataSource();
		newObject.setType(type);
		newObject.setItemKey(itemKey);
		newObject.setFormulaItemKey(formulaItemKey);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTreeViewDataSource();
	}
}
