package com.bokesoft.yigo.meta.form.component.control.tableview;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SubDetailLinkType;
import com.bokesoft.yigo.common.def.TableRowStyle;
import com.bokesoft.yigo.common.def.TableViewRowType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;

/**
 * 表视图组件的行配置对象
 * @author wangyh
 *
 */
public class MetaTableRow extends MetaComponent {
	/** 加载中的行视图默认行数 */
	public static final int DEFAULT_PROMPT_ROW_COUNT = 2;
	/** 行类型 */
	private Integer rowType = TableViewRowType.Fix;
	/** 行上绑定的数据表标识 */
	private String tableKey = "";
	/** 样式，取值为list和tiled */
	private Integer style = TableRowStyle.List;
	/** 列数 */
	private Integer columnCount = 3;
	/** 根组件 */
	private MetaComponent root = null;
	/** 行点击事件 */
	private MetaBaseScript rowClick = null;
	/** 行双击事件 */
	private MetaBaseScript rowDblClick = null;
	/** 焦点行改变事件 */
	private MetaBaseScript focusRowChanged = null;
	/** 行操作集合 */
	private MetaRowActionCollection actionCollection;
	/** 分组列标志集合，当RowType为Group时定义，如果有多列，以逗号(,)隔开 */
	private String groupColumnKeys = "";
	/**
	 * 间隔样式，目前支持值：""（默认）、"Solid"（实线，四周都有）、"None"（无边框）、 "None Solid"
	 * （前一个代表上下，后一个代表左右）、 "Solid None None Solid"（四个按方位，上右下左来设置）。
	 */
	private String separatorStyle = "";
	/** 边框圆角大小,只对solid有效 */
	private Integer separatorRadius = -1;
	/** 间隔颜色 */
	private String separatorColor = "";
	/** 间隔距离左边界的距离 */
	private DefSize separatorOffset = null;
	/** 顶边界 */
	private String topMargin = "";
	/** 显示第一行顶边距 */
	private Boolean isShowFirstMargin = false;
	/** 选中颜色 */
	private String selectColor = "";
	/** 高亮颜色 */
	private String highlightColor = "";
	/** 背景颜色 */
	private String backColor = "";
	/** 索引条指示器 */
	private Boolean indicator = false;
	/** 组头悬停 */
	private Boolean hoverHead = false;
	/** 索引条指示器显示的对应字段 */
	private String indicatorKey = "";
	/** 点击分组头是否隐藏对应的明细行和尾行 */
	private Boolean groupCollapse = false;
	/** 加载中的行视图 */
	private String promptImage = "";
	/** 加载中的行视图行数 */
	private Integer promptRowCount = DEFAULT_PROMPT_ROW_COUNT;
	/** 分组头行，对应明细部分隐藏时的事件 */
	private MetaBaseScript onCollapse = null;
	/** 分组头行，对应明细部分显示时的事件 */
	private MetaBaseScript onExpand = null;
	/** 分页时每页显示的行数 */
	private Integer pageRowCount = 50;
	/** 分页类型 */
	private Integer pageLoadType = PageLoadType.NONE;
	/** 是否显示总行数*/
	private Boolean showTotalRowCount = null;
	/** 是否有子明细*/
	private Boolean hasSubDetail = false;
	/** 子明细的关联方式,-1表示未定义*/
	private Integer linkType = SubDetailLinkType.PARENT;
	/** 子明细外键关联方式的源字段*/
	private String source = "";
	private List<String> sourceFields = new ArrayList<String>();
	/** 设置子明细外键关联方式的目标表字段*/
	private String target = "";
	private List<String> targetFields = new ArrayList<String>();
	/** 联动列表*/
	private String linkList = "";
	/** 联动字段*/
	private String linkFields = "";
	private List<String> linkFieldsAr = new ArrayList<String>();
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { root, rowClick, rowDblClick, focusRowChanged, actionCollection,
				onCollapse, onExpand });
	}

	public static final String TAG_NAME = "TableRow";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置行点击事件
	 *
	 * @param rowClick
	 *            定义
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}

	/**
	 * 取得行击点事件
	 *
	 * @return 定义
	 */
	public MetaBaseScript getRowClick() {
		return this.rowClick;
	}

	/**
	 * 设置行双击事件
	 * @param rowDblClick 行双击事件
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}

	/**
	 * 获取行双击事件
	 * @return 行双击事件
	 */
	public MetaBaseScript getRowDblClick() {
		return rowDblClick;
	}

	/**
	 * 设置行焦点改变事件
	 * @param focusRowChanged 行焦点改变事件
	 */
	public void setFocusRowChanged(MetaBaseScript focusRowChanged) {
		this.focusRowChanged = focusRowChanged;
	}

	/**
	 * 获取行焦点改变事件
	 * @return 行焦点改变事件
	 */
	public MetaBaseScript getFocusRowChanged() {
		return focusRowChanged;
	}

	/**
	 * 设置分组头行点击收缩分组事件
	 * @param onCollapse 分组头行点击收缩分组事件
	 */
	public void setOnCollapse(MetaBaseScript onCollapse) {
		this.onCollapse = onCollapse;
	}

	/**
	 * 获取分组头行点击收缩分组事件
	 * @return 分组头行点击收缩分组事件
	 */
	public MetaBaseScript getOnCollapse() {
		return onCollapse;
	}

	/**
	 * 设置分组头行点击展开分组事件
	 * @param onExpand 分组头行点击展开分组事件
	 */
	public void setOnExpand(MetaBaseScript onExpand) {
		this.onExpand = onExpand;
	}

	/**
	 * 获取分组头行点击展开分组事件
	 * @return 分组头行点击展开分组事件
	 */
	public MetaBaseScript getOnExpand() {
		return onExpand;
	}

	/**
	 * 设置是否显示索引条
	 * @param indicator 是否显示索引条
	 */
	public void setIndicator(Boolean indicator) {
		this.indicator = indicator;
	}

	/**
	 * 获取是否显示索引条
	 * @return 是否显示索引条
	 */
	public Boolean isIndicator() {
		return indicator;
	}

	/**
	 * 设置索引条关联字段标识
	 * @param indicatorKey 索引条关联字段标识
	 */
	public void setIndicatorKey(String indicatorKey) {
		this.indicatorKey = indicatorKey;
	}

	/**
	 * 获取索引条关联字段标识
	 * @return 索引条关联字段标识
	 */
	public String getIndicatorKey() {
		return indicatorKey;
	}

	/**
	 * 设置组头是否允许悬停
	 * @param hoverHead 组头是否允许悬停
	 */
	public void setHoverHead(Boolean hoverHead) {
		this.hoverHead = hoverHead;
	}

	/**
	 * 获取组头是否允许悬停
	 * @return 组头是否允许悬停
	 */
	public Boolean isHoverHead() {
		return hoverHead;
	}

	/**
	 * 设置分组是否允许收缩展开
	 * @param groupCollapse 分组是否允许收缩展开
	 */
	public void setGroupCollapse(Boolean groupCollapse) {
		this.groupCollapse = groupCollapse;
	}

	/**
	 * 获取分组是否允许收缩展开
	 * @return 分组是否允许收缩展开
	 */
	public Boolean isGroupCollapse() {
		return groupCollapse;
	}

	/**
	 * 设置加载时的行视图图片名称
	 * @param promptImage 加载时的行视图图片名称
	 */
	public void setPromptImage(String promptImage) {
		this.promptImage = promptImage;
	}

	/**
	 * 获取加载时的行视图图片名称
	 * @return 加载时的行视图图片名称
	 */
	public String getPromptImage() {
		return promptImage;
	}

	/**
	 * 设置加载时的行视图的数量
	 * @param promptRowCount 加载时的行视图的数量
	 */
	public void setPromptRowCount(Integer promptRowCount) {
		this.promptRowCount = promptRowCount;
	}

	/**
	 * 获取加载时的行视图的数量
	 * @return 加载时的行视图的数量
	 */
	public Integer getPromptRowCount() {
		return promptRowCount;
	}

	/**
	 * 设置分页的单页行数量
	 * @param pageRowCount 分页的单页行数量
	 */
	public void setPageRowCount(Integer pageRowCount) {
		this.pageRowCount = pageRowCount;
	}

	/**
	 * 获取分页的单页行数量
	 * @return 分页的单页行数量
	 */
	public Integer getPageRowCount() {
		return pageRowCount;
	}

	/**
	 * 设置分页的类型
	 * @param pageLoadType 分页类型，参考{@link PageLoadType}
	 */
	public void setPageLoadType(Integer pageLoadType) {
		this.pageLoadType = pageLoadType;
	}

	/**
	 * 获取分页类型
	 * @return 分页类型，参考{@link PageLoadType}
	 */
	public Integer getPageLoadType() {
		return pageLoadType;
	}

	/**
	 * 设置是否显示总行数
	 * @param showTotalRowCount 是否显示总行数
	 */
	public void setShowTotalRowCount(Boolean showTotalRowCount) {
		this.showTotalRowCount = showTotalRowCount;
	}

	/**
	 * 是否显示总行数
	 * @return 是否显示总行数
	 */
	public Boolean isShowTotalRowCount() {
		return this.showTotalRowCount;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (indicator != null){
			if(indicator && indicatorKey.isEmpty()){
				throw new MetaException(MetaException.TABLEROW_NO_INDICATOR_KEY,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.TableRowNoIndicatorKey), getKey()));
			}
		}
		if (root != null) {
			root.doPostProcess(flag, callback);
		}

		if(this.getRowType() == RowType.Detail){
			this.setDetailOnlyShow(root);
			this.setDetailTableKey(root);
		}
	}

	/**
	 * 递归设置明细行中所有组件的数据关联表标识（tableKey），
	 * 全部统一为row设置的tableKey，即组件本身定义的tableKey无效果。
	 * @param parent
	 */
	private void setDetailTableKey(MetaComponent parent) {
		if (parent.getDataBinding() != null) {
			parent.getDataBinding().setTableKey(tableKey);
		}
		if (parent.getComponentCount() > 0) {
			for (int i = 0; i < parent.getComponentCount(); i++) {
				MetaComponent component = parent.getComponent(i);
				this.setDetailTableKey(component);
			}
		}
	}

	/**
	 * 递归设置明细行中所有组件的OnlyShow属性，如果配置中未定义，则默认设置为true
	 * @param parent
	 */
	private void setDetailOnlyShow(MetaComponent parent){
		if(parent.isOnlyShow() == null){
			parent.setOnlyShow(true);
		}
		if(parent.getComponentCount() > 0){
			for(int i=0;i<parent.getComponentCount();i++){
				MetaComponent component = parent.getComponent(i);
				this.setDetailOnlyShow(component);
			}
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
													int runType) throws MetaException {
		AbstractMetaObject resultMetaObject;
		if (MetaConstants.Event_RowClick.equals(tagName)) {
			rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			resultMetaObject = rowClick;
		} else if (MetaConstants.Event_RowDblClick.equals(tagName)) {
			rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			resultMetaObject = rowDblClick;
		} else if (MetaConstants.Event_FocusRowChanged.equals(tagName)) {
			focusRowChanged = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			resultMetaObject = focusRowChanged;
		} else if (MetaConstants.Event_OnCollapse.equals(tagName)) {
			onCollapse = new MetaBaseScript(MetaConstants.Event_OnCollapse);
			resultMetaObject = onCollapse;
		} else if (MetaConstants.Event_OnExpand.equals(tagName)) {
			onExpand = new MetaBaseScript(MetaConstants.Event_OnExpand);
			resultMetaObject = onExpand;
		} else if (tagName.equalsIgnoreCase(MetaRowActionCollection.TAG_NAME)) {
			actionCollection = new MetaRowActionCollection();
			resultMetaObject = actionCollection;
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
			if (resultMetaObject == null) {
				root = MetaComponentFactory.getInstance().newComponent(tagName);
				root.preProcessMetaObject(env, doc, node, flag, runType);
				resultMetaObject = root;
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTableRow newObject = (MetaTableRow) super.clone();
		newObject.setRowType(rowType);
		newObject.setTableKey(tableKey);
		newObject.setGroupColumnKeys(groupColumnKeys);
		newObject.setStyle(style);
		newObject.setColumnCount(columnCount);
		newObject.setSeparatorStyle(separatorStyle);
		newObject.setSeparatorColor(separatorColor);
		newObject.setSeparatorRadius(separatorRadius);
		newObject.setSeparatorOffset(separatorOffset);
		newObject.setTopMargin(topMargin);
		newObject.setShowFirstMargin(isShowFirstMargin);
		newObject.setSelectColor(selectColor);
		newObject.setHighlightColor(highlightColor);
		newObject.setBackColor(backColor);
		newObject.setRoot(root == null ? null : (MetaComponent) root.clone());
		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript) rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript) rowDblClick.clone());
		newObject.setFocusRowChanged(focusRowChanged == null ? null : (MetaBaseScript) focusRowChanged.clone());
		newObject.setOnCollapse(onCollapse == null ? null : (MetaBaseScript) onCollapse.clone());
		newObject.setOnExpand(onExpand == null ? null : (MetaBaseScript) onExpand.clone());
		newObject.setActionCollection(
				actionCollection == null ? null : (MetaRowActionCollection) actionCollection.clone());
		newObject.setIndicator(indicator);
		newObject.setIndicatorKey(indicatorKey);
		newObject.setHoverHead(hoverHead);
		newObject.setGroupCollapse(groupCollapse);
		newObject.setPromptImage(promptImage);
		newObject.setPromptRowCount(promptRowCount);
		newObject.setPageRowCount(pageRowCount);
		newObject.setPageLoadType(pageLoadType);
		newObject.setShowTotalRowCount(showTotalRowCount);
		newObject.setLinkType(linkType);
		newObject.setSource(source);
		newObject.setTarget(target);
		newObject.setLinkFields(linkFields);
		newObject.setLinkList(linkList);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableRow();
	}

	/**
	 * 设置间隔距离左边界的距离
	 * @param separatorOffset 间隔距离左边界的距离
	 */
	public void setSeparatorOffset(DefSize separatorOffset) {
		this.separatorOffset = separatorOffset;
	}

	/**
	 * 获取间隔距离左边界的距离
	 * @return 间隔距离左边界的距离
	 */
	public DefSize getSeparatorOffset() {
		return separatorOffset;
	}

	/**
	 * 设置行类型
	 *
	 * @param rowType
	 *            行类型
	 */
	public void setRowType(Integer rowType) {
		this.rowType = rowType;
	}

	/**
	 * 取得行类型
	 *
	 * @return 行类型
	 */
	public Integer getRowType() {
		return this.rowType;
	}

	/**
	 * 设置表标识
	 *
	 * @param tableKey
	 *            表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 取得表标识
	 *
	 * @return 表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}

	/**
	 * 设置样式
	 *
	 * @param style
	 *            样式
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}

	/**
	 * 取得样式
	 *
	 * @return 样式
	 */
	public Integer getStyle() {
		return this.style;
	}

	/**
	 * 设置列数
	 *
	 * @param columnCount
	 *            列数
	 */
	public void setColumnCount(Integer columnCount) {
		this.columnCount = columnCount;
	}

	/**
	 * 取得列数
	 *
	 * @return 列数
	 */
	public Integer getColumnCount() {
		return this.columnCount;
	}

	/**
	 * 设置根组件
	 *
	 * @param root
	 *            根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	/**
	 * 取得根组件
	 *
	 * @return 根组件
	 */
	public MetaComponent getRoot() {
		return this.root;
	}

	/**
	 * 获取分组列标识集合
	 *
	 * @return 分组列标识集合
	 */
	public String getGroupColumnKeys() {
		return groupColumnKeys;
	}

	/**
	 * 设置分组列标识集合
	 *
	 * @param groupColumnKeys
	 *            分组列标识集合
	 */
	public void setGroupColumnKeys(String groupColumnKeys) {
		this.groupColumnKeys = groupColumnKeys;
	}

	/**
	 * 获取间隔样式
	 *
	 * @return 间隔样式
	 */
	public String getSeparatorStyle() {
		return separatorStyle;
	}

	/**
	 * 设置间隔样式
	 *
	 * @param separatorStyle
	 *            间隔样式
	 */
	public void setSeparatorStyle(String separatorStyle) {
		this.separatorStyle = separatorStyle;
	}

	/**
	 * 取得边框圆角大小
	 * @return 大小
	 */
	public Integer getSeparatorRadius() {
		return this.separatorRadius;
	}

	/**
	 * 设置边框圆角大小
	 * @param separatorRadius 大小
	 */
	public void setSeparatorRadius(Integer separatorRadius) {
		this.separatorRadius = separatorRadius;
	}

	/**
	 * 获取间隔颜色
	 *
	 * @return 间隔颜色
	 */
	public String getSeparatorColor() {
		return separatorColor;
	}

	/**
	 * 设置间隔颜色
	 *
	 * @param separatorColor
	 *            间隔颜色
	 */
	public void setSeparatorColor(String separatorColor) {
		this.separatorColor = separatorColor;
	}

	/**
	 * 获取顶边界
	 *
	 * @return 顶边界
	 */
	public String getTopMargin() {
		return topMargin;
	}

	/**
	 * 设置顶边界
	 *
	 * @param topMargin
	 *            顶边界
	 */
	public void setTopMargin(String topMargin) {
		this.topMargin = topMargin;
	}

	/**
	 * 获取行操作定义集合
	 *
	 * @return 行操作定义集合
	 */
	public MetaRowActionCollection getActionCollection() {
		return actionCollection;
	}

	/**
	 * 设置行操作定义集合
	 *
	 * @param actionCollection
	 *            行操作定义集合
	 */
	public void setActionCollection(MetaRowActionCollection actionCollection) {
		this.actionCollection = actionCollection;
	}

	/**
	 * 设置选中颜色
	 *
	 * @param selectColor
	 *            选中颜色
	 */
	public void setSelectColor(String selectColor) {
		this.selectColor = selectColor;
	}

	/**
	 * 获取选中颜色
	 *
	 * @return 选中颜色
	 */
	public String getSelectColor() {
		return selectColor;
	}

	/**
	 * 设置高亮颜色
	 *
	 * @param highlightColor 高亮颜色
	 */
	public void setHighlightColor(String highlightColor) {
		this.highlightColor = highlightColor;
	}

	/**
	 * 获取高亮颜色
	 *
	 * @return 高亮颜色
	 */
	public String getHighlightColor() {
		return highlightColor;
	}

	/**
	 * 设置是否显示第一行顶边距
	 *
	 * @param isShowFirstMargin
	 *            是否显示第一行顶边距
	 */
	public void setShowFirstMargin(Boolean isShowFirstMargin) {
		this.isShowFirstMargin = isShowFirstMargin;
	}

	/**
	 * 获取是否显示第一行顶边距
	 *
	 * @return 是否显示第一行顶边距
	 */
	public Boolean isShowFirstMargin() {
		return isShowFirstMargin;
	}

	/**
	 * 设置背景颜色
	 *
	 * @param backColor
	 *            背景颜色
	 */

	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	/**
	 * 获取背景颜色
	 *
	 * @return 背景颜色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 获取是否有子明细
	 *
	 * @return 是否有子明细
	 */
	public Boolean hasSubDetail() {
		return hasSubDetail;
	}

	/**
	 * 设置是否有子明细
	 *
	 * @param hasSubDetail
	 *            是否有子明细
	 */
	public void setHasSubDetail(Boolean hasSubDetail) {
		this.hasSubDetail = hasSubDetail;
	}

	/**
	 * 获取子明细的关联方式
	 *
	 * @return 子明细的关联方式
	 */
	public Integer getLinkType() {
		return linkType;
	}

	/**
	 * 设置子明细的关联方式
	 *
	 * @param linkType
	 *            子明细的关联方式
	 */
	public void setLinkType(Integer linkType) {
		this.linkType = linkType;
	}

	/**
	 * 获取子明细外键关联的源表字段
	 * @return 子明细外键关联的源表字段
	 */
	public String getSource() {
		return source;
	}

	/**
	 * 设置子明细外键关联的源表字段
	 * @param source 子明细外键关联的源表字段
	 */
	public void setSource(String source) {
		this.source = source;
		this.sourceFields.clear();
		if( source != null && !source.isEmpty() ) {
			String[] sources = source.split(",");
			for(int i=0;i<sources.length;i++){
				sourceFields.add(sources[i]);
			}
		}
	}

	/**
	 * 获取子明细外键关联的目标表字段
	 * @return 目标
	 */
	public String getTarget() {
		return target;
	}

	/**
	 * 设置子明细外检关联的目标表字段
	 * @param target 目标字段标识
	 */
	public void setTarget(String target) {
		this.target = target;
		this.targetFields.clear();
		if(target != null && !target.isEmpty()) {
			String[] targets = target.split(",");
			for(int i=0;i<targets.length;i++){
				targetFields.add(targets[i]);
			}
		}
	}


	public List<String> getSourceFields() {
		return sourceFields;
	}

	public List<String> getTargetFields() {
		return targetFields;
	}

	public void setSourceFields(List<String> sourceFields) {
		this.sourceFields = sourceFields;
	}

	public void setTargetFields(List<String> targetFields) {
		this.targetFields = targetFields;
	}
	
	public String getLinkFields() {
		return linkFields;
	}

	public void setLinkFields(String fields) {
		this.linkFields = fields;
		this.linkFieldsAr.clear();
		if(fields != null && !fields.isEmpty()) {
			String[] field = fields.split(",");
			for(int i=0;i<field.length;i++){
				linkFieldsAr.add(field[i]);
			}
		}
	}
	
	public String getLinkList() {
		return linkList;
	}

	public void setLinkList(String linkList) {
		this.linkList = linkList;
	}

	public List<String> getLinkFieldsAr() {
		return linkFieldsAr;
	}

	public void setLinkFieldsAr(List<String> linkFieldsAr) {
		this.linkFieldsAr = linkFieldsAr;
	}


	@Override
	public int getControlType() {
		return ControlType.OTHER;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public void merge(MetaComponent meta) {

		super.merge(meta);

		MetaTableRow metaTableRow = (MetaTableRow)meta;

	}
}
