package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaToggleButtonProperties extends AbstractMetaObject implements IPropertyMerger<MetaToggleButtonProperties>{
	/**选中时文字*/
	private String textOn ="";
	/**未选中时文字*/
	private String textOff ="";
	/**图片*/
	private String icon = "";
	/**选中时图片*/
	private String iconOn ="";
	/**未选中时图片*/
	private String iconOff ="";
	/**图片位置*/
	private Integer iconLocation = IconLocationType.LEFT;
	/** 点击事件 */
	private MetaBaseScript onClick = null;
	
	
	/**
	 * 获取选中文字
	 * @return
	 */
	public String getTextOn() {
		return textOn;
	}

	/**
	 * 设置选中文字
	 * @param textOn 选中文字
	 */
	public void setTextOn(String textOn) {
		this.textOn = textOn;
	}

	/**
	 * 获取未选中文字
	 * @return 
	 */
	public String getTextOff() {
		return textOff;
	}

	/**
	 * 设置未选中文字
	 * @param textOff 未选中文字
	 */
	public void setTextOff(String textOff) {
		this.textOff = textOff;
	}
	
	/**
	 * 获取图片
	 * @return
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 设置图片
	 * @param icon 图片
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 获取选中图片
	 * @return
	 */
	public String getIconOn() {
		return iconOn;
	}

	/**
	 * 设置选中图片
	 * @param iconOn 选中图片
	 */
	public void setIconOn(String iconOn) {
		this.iconOn = iconOn;
	}

	/**
	 * 获取未选中图片
	 * @return 未选中图片
	 */
	public String getIconOff() {
		return iconOff;
	}

	/**
	 * 设置未选中图片
	 * @param iconOff 未选中图片
	 */
	public void setIconOff(String iconOff) {
		this.iconOff = iconOff;
	}

	/**
	 * 获取图片方向
	 * @return
	 */
	public Integer getIconLocation() {
		return iconLocation;
	}

	/**
	 * 设置图片方向
	 * @param iconLocation 图片方向
	 */
	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}
	
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}

	@Override
	public void merge(MetaToggleButtonProperties properties) {
		if(this.textOn == null){
			this.textOn = properties.getTextOn();
		}
		if(this.textOff == null){
			this.textOff = properties.getTextOff();
		}
		if(this.icon == null){
			this.icon = properties.getIcon();
		}
		if(this.iconOn == null){
			this.iconOn = properties.getIconOn();
		}
		if(this.iconOff == null){
			this.iconOff = properties.getIconOff();
		}
		if(this.iconLocation == -1){
			this.iconLocation = properties.getIconLocation();
		}
		if( this.onClick == null ) {
			this.onClick = properties.getOnClick();
		}
		
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( onClick != null ) {
			list.add(onClick);
		}
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaToggleButtonProperties newObject = new MetaToggleButtonProperties();
		newObject.setTextOn(textOn);
		newObject.setTextOff(textOff);
		newObject.setIcon(icon);
		newObject.setIconOn(iconOn);
		newObject.setIconOff(iconOff);
		newObject.setIconLocation(iconLocation);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaToggleButtonProperties();
	}

}
