package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 搜索框属性定义类
 * @author wangyh
 *
 */
public class MetaSearchBoxProperties extends AbstractMetaObject {
	/** 提供者标识 */
	private String providerKey = null;
	/** 提供者公式标识 */
	private String providerFormulaKey = null;
	/** 提供者依赖 */
	private String providerDependency = null;
	
	/**
	 * 设置提供者标识
	 * @param providerKey 提供者标识
	 */
	public void setProviderKey(String providerKey) {
		this.providerKey = providerKey;
	}
	
	/**
	 * 取得提供者标识
	 * @return 提供者标识
	 */
	public String getProviderKey(){
		return providerKey;
	}
	
	/**
	 * 设置提供者公式标识
	 * @param providerFormulaKey 公式标识
	 */
	public void setProviderFormulaKey(String providerFormulaKey) {
		this.providerFormulaKey = providerFormulaKey;
	}
	
	/**
	 * 设置提供者依赖
	 * @param providerDependency 依赖
	 */
	public void setProviderDependency(String providerDependency){
		this.providerDependency = providerDependency;
	}
	
	/**
	 * 取得提供者公式标识
	 * @return 公式标识
	 */
	public String getProviderFormulaKey(){
		return this.providerFormulaKey;
	}
	
	/**
	 * 取得提供者依赖
	 * @return 依赖
	 */
	public String getProviderDependency(){
		return this.providerDependency;
	}
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSearchBoxProperties newObject = new MetaSearchBoxProperties();
		newObject.setProviderKey(providerKey);
		newObject.setProviderFormulaKey(providerFormulaKey);
		newObject.setProviderDependency(providerDependency);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSearchBoxProperties();
	}


}
