package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridDesignerProp描述表格模板单元格中的自定义属性
 * @author wangyh
 *
 */
public class MetaGridDesignerProp extends AbstractMetaObject {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 数据类型 */
	private Integer dataType = -1;
	/** 编辑器类型 */
	private String editorType = "";
	/** 编辑器实现 */
	private String editorImpl = "";
	/** 字典标识 */
	private String itemKey = "";
	/** 列表项集合 */
	private MetaListBoxItemCollection items = null;
	
	public MetaGridDesignerProp() {
		super();
		items = new MetaListBoxItemCollection();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { items });
	}
	
	public static final String TAG_NAME = "GridDesignerProp";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置数据类型
	 * @param dataType 数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}
	
	/**
	 * 取得数据类型
	 * @return 数据类型
	 */
	public Integer getDataType() {
		return this.dataType;
	}
	
	/**
	 * 设置编辑器类型
	 * @param editorType 编辑器类型
	 */
	public void setEditorType(String editorType) {
		this.editorType = editorType;
	}
	
	/**
	 * 取得编辑器类型
	 * @return 编辑器类型
	 */
	public String getEditorType() {
		return this.editorType;
	}
	
	/**
	 * 设置编辑器实现
	 * @param editorImpl 编辑器实现
	 */
	public void setEditorImpl(String editorImpl) {
		this.editorImpl = editorImpl;
	}
	
	/**
	 * 取得编辑器实现
	 * @return 编辑器实现
	 */
	public String getEditorImpl() {
		return this.editorImpl;
	}
	
	/**
	 * 设置字典标识
	 * @param itemKey 字典标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}
	
	/**
	 * 取得字典标识
	 * @return 字典标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}
	
	/**
	 * 设置列表项集合
	 * @param items 列表项集合
	 */
	public void setItems(MetaListBoxItemCollection items) {
		this.items = items;
	}
	
	/**
	 * 取得列表项集合
	 * @return 列表项集合
	 */
	public MetaListBoxItemCollection getItems() {
		return this.items;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaGridDesignerProp newObject = (MetaGridDesignerProp)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDataType(dataType);
		newObject.setEditorType(editorType);
		newObject.setEditorImpl(editorImpl);
		newObject.setItemKey(itemKey);
		newObject.setItems(items == null ? null : (MetaListBoxItemCollection)items.clone());
		
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridDesignerProp();
	}
}
