package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.meta.base.*;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import org.apache.commons.lang3.StringUtils;

public class MetaFilter extends GenericKeyCollectionWithKey<MetaFilterValue> implements IPropertyMerger<MetaFilter> {
	/** 对应字典的ItemKey*/
	private String itemKey = "";
	/** 对应过滤的caption*/
	private String filterCaption = "";
	/** 过滤的类型 */
	private Integer type = -1;
	/** 过滤表达式 */
	private String expression = "";
	/** 查询过滤条件 */
	private String query = "";
	/** 运算符 */
	private Integer op = FilterOptSign.AND;
	/** 过滤条件依赖的组件的集合*/
	private String filterDependency = "";
	/** 过滤条件所依赖的字段*/
	private List<String> dependentFields = new ArrayList<String>();
	/** filter的条件， 当条件满足时计算filter ， 有多个条件满足时 只计算第一个*/
	private String condition = "";
	/** 自定义开发接口实现类类名 */
	private String impl = "";
	private String key = "";

	public MetaFilter() {
		super();
	}

	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}

	public String getItemKey() {
		return itemKey;
	}

	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}

	public String getFilterCaption() {
		return filterCaption;
	}

	public void setFilterCaption(String filterCaption) {
		this.filterCaption = filterCaption;
	}

	public void setOp(int op){
		this.op = op;
	}

	public int getOp(){
		return this.op;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	public static final String TAG_NAME = "Filter";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置过滤类型
	 * @param type 过滤类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 取得过滤类型
	 * @return 过滤类型
	 */
	public Integer getType() {
		return this.type;
	}

	/**
	 * 设置表达式
	 * @param expression 表达式
	 */
	public void setExpression(String expression) {
		this.expression = expression;
	}

	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public String getExpression() {
		return this.expression;
	}

	/**
	 * 设置查询过滤条件
	 * @param query 查询过滤条件
	 */
	public void setQuery(String query) {
		this.query = query;
	}

	/**
	 * 取得查询过滤条件
	 * @return 查询过滤条件
	 */
	public String getQuery() {
		return this.query;
	}

	/**
	 * 设置过滤的启用条件
	 * @param cond 过滤的启用条件
	 */
	public void setCondition(String cond) {
		this.condition = cond;
	}

	/**
	 * 获取过滤的启用条件
	 * @return 过滤的启用条件
	 */
	public String getCondition() {
		return this.condition;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaFilterValue.TAG_NAME.equals(tagName) ) {
			MetaFilterValue fieldValue = new MetaFilterValue();
			fieldValue.setFilter(this);
			fieldValue.preProcessMetaObject(env, doc, node, flag, runType);
			if (runType == AppRunType.Dev){
				int i = 1;
				if (StringUtils.isEmpty(fieldValue.getKey())){
					fieldValue.setKey(i+"");
				}
				while (this.containsKey(fieldValue.getKey())){
					fieldValue.setKey(i+"");
					i++;
				}
			}
			this.add(fieldValue);
			resultMetaObject = fieldValue;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFilter newObject = (MetaFilter) super.clone();
		newObject.setItemKey(this.itemKey);
		newObject.setFilterCaption(this.filterCaption);
		newObject.setType(this.type);
		newObject.setExpression(this.expression);
		newObject.setQuery(this.query);
		newObject.setOp(this.op);
		newObject.setCondition(this.condition);
		newObject.setFilterDependency(this.filterDependency);
		newObject.setDependentFields(dependentFields);
		newObject.setImpl(this.impl);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFilter();
	}

	protected void addDependedField(String fields){
		if(fields == null || fields.length() == 0){
			return;
		}
		if(!dependentFields.contains(fields)){
			dependentFields.add(fields);
		}
	}

	/**
	 * 返回依赖字段，字段key小写
	 * @return 返回依赖字段集合
	 */
	public List<String> getDependedFields(){
		return dependentFields;
	}

	/**
	 * 设置依赖字段,拓展克隆的时候需要
	 * @param dependentFields 依赖字段
	 */
	public void setDependentFields(List<String> dependentFields) {
		this.dependentFields = dependentFields;
	}

	/**
	 * 取得依赖字段定义
	 * @return 依赖字段定义，以,分隔，比如[A,B]
	 */
	public String getFilterDependency(){
		return this.filterDependency;
	}

	/**
	 * 设置依赖字段定义
	 * @param dependency 依赖字段定义，以,分隔，比如[A,B]
	 */
	public void setFilterDependency (String dependency){
		this.filterDependency = dependency;

		if(dependency != null && dependency.length() > 0){
			String[] fields = this.filterDependency.split(",");
			for(String field : fields){
				dependentFields.add(field);
			}
		}
	}

	/**
	 * 设置自定义实现类类名,自定义类型时有效
	 * @param impl 实现类全路径名称
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}

	/**
	 * 取得自定义实现类类名
	 * @return 实现类全路径名称
	 */
	public String getImpl(){
		return this.impl;
	}
	/**
	 * 用于统一处理类似的集合类
	 *
	 * @return
	 */
	public MetaFilterValue get(int index) {
		synchronized(elementMap) {
			return (MetaFilterValue) elementMap.values().toArray()[index];
		}
	}
	public boolean isEmpty() {
		synchronized(elementMap) {
			return elementMap.isEmpty();
		}
	}
	public List<MetaFilterValue> getList() {
        List<MetaFilterValue> list = new ArrayList(elementMap.values());
		return list;
	}
	@Override
	public void merge(MetaFilter metaFilterValues) {
		if (this.type == -1){
			this.type = metaFilterValues.getType();
		}
		if (this.expression == null){
			this.expression = metaFilterValues.getExpression();
		}
		if (this.query == null){
			this.query = metaFilterValues.getQuery();
		}
		if (this.op == -1){
			this.op = metaFilterValues.getOp();
		}
		if (this.condition == null){
			this.condition = metaFilterValues.getCondition();
		}
		if (this.filterDependency == null){
			this.filterDependency = metaFilterValues.getFilterDependency();
		}
		if (this.filterCaption == null){
			this.filterCaption = metaFilterValues.getFilterCaption();
		}
		if (this.impl == null){
			this.impl = metaFilterValues.getImpl();
		}
		if (metaFilterValues.size()>0){
			for (MetaFilterValue metaFilterValue : metaFilterValues) {
				if (this.containsKey(metaFilterValue.getKey())){
					this.get(metaFilterValue.getKey()).merge(metaFilterValue);
				}else {
					this.add(metaFilterValue);
				}
			}
		}
	}
}
