package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaDropdownItem extends MetaComponent {
	private String key = "";
	/** 下拉项文本 */
	private String text = "";
	/** 下拉项点击事件 */
	private MetaBaseScript onClick = null;
	/** 是否分隔项 */
	private Boolean separator = false;
	
	public MetaDropdownItem() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if ( onClick != null ) {
			list.add(onClick);
		}
	}
	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置下拉项文本
	 * @param text 文本
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	/**
	 * 取得下拉项文本
	 * @return 文本
	 */
	public String getText() {
		return this.text;
	}
	
	/**
	 * 设置下拉项点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}
	
	/**
	 * 取得下拉项点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}
	
	/**
	 * 设置是否分隔线
	 * @param separator 是否分隔线标志
	 */
	public void setSeparator(Boolean separator) {
		this.separator = separator;
	}
	
	/**
	 * 取得是否分隔线
	 * @return 是否分隔线标志
	 */
	public Boolean getSeparator() {
		return this.separator;
	}

	public static final String TAG_NAME = "DropdownItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDropdownItem newObject = new MetaDropdownItem();
		newObject.setKey(key);
		newObject.setText(text);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setSeparator(separator);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDropdownItem();
	}

	@Override
	public int getControlType() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}
}
