package com.bokesoft.yigo.meta.form.component.control.navigationlist;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaNavigationListRow extends AbstractMetaObject {

	public static final String TAG_NAME = "NavigationListRow";

	/** 背景色 */
	private String backColor = "";
	/** 前景色 */
	private String foreColor = "";
	/** 字体大小 */
	private Integer fontSize = -1;
	/** 高亮背景色 */
	private String highlightColor = "";
	
	/** 内边距 */
	private String padding = "";
	/** 左内边距的宽度 */
	private String leftPadding = "";
	/** 右内边距的宽度 */
	private String rightPadding = "";
	/** 上内边距的宽度 */
	private String topPadding = "";
	/** 下内边距的宽度 */
	private String bottomPadding = "";

	/**
	 * 获取背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 设置背景色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	/**
	 * 获取前景色
	 * @return 前景色
	 */
	public String getForeColor() {
		return foreColor;
	}

	/**
	 * 设置前景色
	 * @param foreColor 前景色
	 */
	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}

	/**
	 * 获取字体大小
	 * @return 字体大小
	 */
	public Integer getFontSize() {
		return fontSize;
	}

	/**
	 * 设置字体大小
	 * @param fontSize 字体大小
	 */
	public void setFontSize(Integer fontSize) {
		this.fontSize = fontSize;
	}

	/**
	 * 获取高亮背景色
	 * @return 高亮背景色
	 */
	public String getHighlightColor() {
		return highlightColor;
	}

	/**
	 * 设置高亮背景色
	 * @param highlightColor 高亮背景色
	 */
	public void setHighlightColor(String highlightColor) {
		this.highlightColor = highlightColor;
	}
	
	/**
	 * 设置内边距
	 * @param padding 内边距
	 */
	public void setPadding(String padding) {
		this.padding = padding;
	}
	
	/**
	 * 获取内边距
	 * @return 内边距
	 */
	public String getPadding() {
		return padding;
	}
	
	/**
	 * 设置上内边距属性
	 * @param topPadding 上内边距属性
	 */
	public void setTopPadding(String topPadding) {
		this.topPadding = topPadding;
	}
	
	/**
	 * 获取上内边距属性
	 * @return 上内边距属性
	 */
	public String getTopPadding() {
		return topPadding;
	}
	
	/**
	 * 设置右内边距属性
	 * @param rightPadding 右内边距属性
	 */
	public void setRightPadding(String rightPadding) {
		this.rightPadding = rightPadding;
	}
	
	/**
	 * 获取右内边距属性
	 * @return 右内边距属性
	 */
	public String getRightPadding() {
		return rightPadding;
	}
	
	/**
	 * 设置下内边距属性
	 * @para bottomPadding 下内边距属性
	 */
	public void setBottomPadding(String bottomPadding) {
		this.bottomPadding = bottomPadding;
	}
	
	/**
	 * 获取下内边距属性
	 * @return 下内边距属性
	 */
	public String getBottomPadding() {
		return bottomPadding;
	}
	
	/**
	 * 设置左内边距属性
	 * @param leftPadding 左内边距属性
	 */
	public void setLeftPadding(String leftPadding) {
		this.leftPadding = leftPadding;
	}
	
	/**
	 * 获取左内边距属性
	 * @return 左内边距属性
	 */
	public String getLeftPadding() {
		return leftPadding;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNavigationListRow metaRow = new MetaNavigationListRow();
		metaRow.setBackColor(backColor);
		metaRow.setForeColor(foreColor);
		metaRow.setFontSize(fontSize);
		metaRow.setHighlightColor(highlightColor);
		metaRow.setPadding(padding);
		metaRow.setLeftPadding(leftPadding);
		metaRow.setRightPadding(rightPadding);
		metaRow.setTopPadding(topPadding);
		metaRow.setBottomPadding(bottomPadding);
		return metaRow;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNavigationListRow();
	}

}
