package com.bokesoft.yigo.meta.form.component.control.listview;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;

public class MetaGallery extends MetaEditView {
	public static final String TAG_NAME = ControlType.STR_GALLERY;
	/** 是否循环显示 */
	private Boolean repeat = false;
	/** 单元间隔*/
	private Integer cellGap = 0;
	/** 是否显示指示器*/
	private Boolean indicator = true;
	/** 是否显示页码*/
	private Boolean pagination = false;
	/** 指示器位置*/
	private Integer indicatorLocation = -1;
	/** 除了中间项外的其他项的显示比例，取值为0-1*/
	private Float displayRatio = 1f;
	
	/**
	 * 设置是否循环显示
	 * @param repeat 是否循环显示
	 */
	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}
	
	/**
	 * 是否循环显示
	 * @return 是否循环显示
	 */
	public Boolean isRepeat() {
		return this.repeat;
	}
	
	/**
	 * 设置单元项的间隔
	 * @param cellGap 间隔
	 */
	public void setCellGap(Integer cellGap) {
		this.cellGap = cellGap;
	}
	
	/**
	 * 获取单元项的间隔
	 * @return 间隔
	 */
	public Integer getCellGap() {
		return cellGap;
	}

	/**
	 * 设置是否显示指示器
	 * @param indicator 是否显示指示器
	 */
	public void setIndicator(Boolean indicator) {
		this.indicator = indicator;
	}
	
	/**
	 * 是否显示指示器
	 * @return 是否显示指示器
	 */
	public Boolean isIndicator() {
		return indicator;
	}
	
	/**
	 * 设置是否显示页码
	 * @param pagination 是否显示页码
	 */
	public void setPagination(Boolean pagination) {
		this.pagination = pagination;
	}
	
	/**
	 * 是否显示页码
	 * @return 是否显示页码
	 */
	public Boolean isPagination() {
		return pagination;
	}

	/**
	 * 设置指示器位置
	 * @param indicatorLocation 指示器位置，参考{@link com.bokesoft.yigo.common.def.HAlignment}
	 */
	public void setIndicatorLocation(Integer indicatorLocation) {
		this.indicatorLocation = indicatorLocation;
	}
	
	/**
	 * 获取指示器位置
	 * @return 指示器位置，参考{@link com.bokesoft.yigo.common.def.HAlignment}
	 */
	public Integer getIndicatorLocation() {
		return indicatorLocation;
	}
	
	/**
	 * 设置中间项外的其他项的显示比例，取值为0-1
	 * @param displayRatio 显示比例
	 */
	public void setDisplayRatio(Float displayRatio) {
		this.displayRatio = displayRatio;
	}
	
	/**
	 * 获取中间项外的其他项的显示比例，取值为0-1
	 * @return 显示比例
	 */
	public Float getDisplayRatio() {
		return displayRatio;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.GALLERY;
	}
 
	@Override
	public AbstractMetaObject clone() {
		MetaGallery newObject = (MetaGallery)super.clone();
		newObject.setRepeat(repeat);
		newObject.setCellGap(cellGap);
		newObject.setIndicator(indicator);
		newObject.setIndicatorLocation(indicatorLocation);
		newObject.setPagination(pagination);
		newObject.setDisplayRatio(displayRatio);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGallery();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public int getDefaultPromptRowCount() {
		return 3;
	}
	
	@Override
	public int getDefaultOrientation() {
		return OrientationType.Horizontal;
	}
}
