package com.bokesoft.yigo.meta.form.component.control.listlayoutview;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;

public class MetaRowLayout extends KeyPairMetaObject {

	/** 行布局的标识 */
	private String key = "";

	/** 行布局的说明 */
	private String caption = "";

	public static final String TAG_NAME = "RowLayout";

	/**
	 * 获取行布局标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置行布局标识
	 * @param key 列集合
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取行布局说明
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置行布局说明
	 * @param caption 行布局说明
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {

		MetaPanel panel = (MetaPanel) MetaComponentFactory.getInstance().newComponent(tagName);
		panel.preProcessMetaObject(env, doc, node, flag, runType);
		this.setLayout(panel);

		
		return panel;
	}

	/** 行布局信息 */
	private MetaPanel layout = null;

	/**
	 * 设置行布局信息
	 * @param panel 行布局
	 */
	public void setLayout(MetaPanel panel) {
		if (panel != null) {
			this.layout = panel;
		}
	}

	/**
	 * 获取行布局信息
	 */
	public MetaPanel getLayout() {
		return layout;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRowLayout newObj = new MetaRowLayout();
		newObj.setKey(key);
		newObj.setCaption(caption);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRowLayout();
	}

}
