package com.bokesoft.yigo.meta.form.component.control.listlayoutview;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;

public class MetaListLayoutView extends MetaListView {
	public static final String TAG_NAME = ControlType.STR_LISTLAYOUTVIEW;

	/** 行布局定义集合*/
	private MetaRowLayoutCollection rowLayoutCollection = null;
	
	/** 显示排列的重复数  */
	private Integer repeatCount = 1;
	
	/**
	 * 获取显示排列的重复数
	 * @return
	 */
	public Integer getRepeatCount() {
		return repeatCount;
	}

	/**
	 * 设置显示排列的重复数
	 * @param repeatCount
	 */
	public void setRepeatCount(Integer repeatCount) {
		this.repeatCount = repeatCount;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.LISTLAYOUTVIEW;
	}
	
	public MetaListLayoutView() {
		this.rowLayoutCollection = new MetaRowLayoutCollection();
	}

	/**
	 * 获取行布局集合
	 */
	public MetaRowLayoutCollection getRowLayoutCollection() {
		return rowLayoutCollection;
	}

	/**
	 * 设置行布局集合
	 * @param rowLayoutCollection 列集合
	 */
	public void setRowLayoutCollection(MetaRowLayoutCollection rowLayoutCollection) {
		this.rowLayoutCollection = rowLayoutCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> listLayout) {
		super.getChildMetaObjects(listLayout);
		addAll(listLayout, new AbstractMetaObject[] { rowLayoutCollection, this.rowLayoutCollection });
	}


	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		Iterator<MetaRowLayout> it = this.rowLayoutCollection.iterator();
		
		MetaRowLayout rowLayout = null;
		while(it.hasNext()){
			rowLayout = it.next();
			rowLayout.doPostProcess(flag, callback);
		}
		
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaRowLayoutCollection.TAG_NAME)) {
			rowLayoutCollection = new MetaRowLayoutCollection();
			resultMetaObject = rowLayoutCollection;
		} 
		if ( resultMetaObject == null ) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaListLayoutView newObject = (MetaListLayoutView)super.clone();
		newObject.setRowLayoutCollection(rowLayoutCollection == null ? null : (MetaRowLayoutCollection)rowLayoutCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaListLayoutView();
	}
}