package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 验证框配置对象 Created by wangfeng on 2018/4/13.
 */

public class MetaValidateBox extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_VALIDATEBOX;

	/** 提示文本 */
	private String promptText = "";

	/** 是否禁用软键盘，针对带有输入框的组件*/
	private Boolean disableKeyboard;
	
	/**
	 * 获取提示文本
	 *
	 * @return 提示文本，默认值为{@link #promptText}
	 */
	public String getPromptText() {
		return promptText;
	}

	/**
	 * 设置提示文本
	 *
	 * @param promptText
	 *            提示文本，默认值为{@link #promptText}
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}
	
	@Override
	public int getControlType() {
		return ControlType.VALIDATEBOX;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaValidateBox newInstance() {
		return new MetaValidateBox();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public MetaValidateBox clone() {
		MetaValidateBox meta = (MetaValidateBox) super.clone();
		meta.setPromptText(promptText);
		meta.setDisableKeyboard(disableKeyboard);
		return meta;
	}

}
