package com.bokesoft.yigo.meta.form.component.control;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;

/**
 * 状态按钮配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaToggleButton extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TOGGLEBUTTON;
	
	private MetaToggleButtonProperties properties = new MetaToggleButtonProperties();
	
	/**
	 * 获取选中文字
	 * @return
	 */
	public String getTextOn() {
		return this.properties.getTextOn();
	}

	/**
	 * 设置选中文字
	 * @param textOn 选中文字
	 */
	public void setTextOn(String textOn) {
		this.properties.setTextOn(textOn);
	}

	/**
	 * 获取未选中文字
	 * @return 
	 */
	public String getTextOff() {
		return this.properties.getTextOff();
	}

	/**
	 * 设置未选中文字
	 * @param textOff 未选中文字
	 */
	public void setTextOff(String textOff) {
		this.properties.setTextOff(textOff);
	}
	
	/**
	 * 获取图片
	 * @return
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}

	/**
	 * 设置图片
	 * @param icon 图片
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}

	/**
	 * 获取选中图片
	 * @return
	 */
	public String getIconOn() {
		return this.properties.getIconOn();
	}
	
	/**
	 * 设置选中图片
	 * @param iconOn 选中图片
	 */
	public void setIconOn(String iconOn) {
		this.properties.setIconOn(iconOn);
	}

	/**
	 * 获取未选中图片
	 * @return 未选中图片
	 */
	public String getIconOff() {
		return this.properties.getIconOff();
	}

	/**
	 * 设置未选中图片
	 * @param iconOff 未选中图片
	 */
	public void setIconOff(String iconOff) {
		this.properties.setIconOff(iconOff);
	}

	/**
	 * 获取图片方向
	 * @return
	 */
	public int getIconLocation() {
		return this.properties.getIconLocation();
	}

	/**
	 * 设置图片方向
	 * @param iconLocation 图片方向
	 */
	public void setIconLocation(int iconLocation) {
		this.properties.setIconLocation(iconLocation);
	}
	
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		properties.setOnClick(onClick);
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return properties.getOnClick();
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TOGGLEBUTTON;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaToggleButton newObject = (MetaToggleButton)super.clone();
		newObject.setProperties(properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaToggleButton();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}
}
