package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateListProperties;

public class MetaStateList extends MetaComponent {
	private MetaStateListProperties properties = new MetaStateListProperties();
	public MetaStateList() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.STATELIST;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaStateListProperties) properties;
	}

	public static final String TAG_NAME = ControlType.STR_STATELIST;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaStateList newObject = (MetaStateList)super.clone();
		newObject.setProperties((MetaStateListProperties)properties.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStateList();
	}

}
