package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSegmentedControlProperties;

/**
 * 下拉框配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaSegmentedControl extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_SEGMENTEDCONTROL;
	
	private MetaSegmentedControlProperties properties = new MetaSegmentedControlProperties();

	public MetaSegmentedControl() {
		super();
		
	}

	/**
	 * 设置是否可编辑
	 * 
	 * @param isEditable
	 *            是否可编辑
	 */
	public void setEditable(Boolean isEditable) {
		this.properties.setEditable(isEditable);
	}

	/**
	 * 获取是否可编辑
	 * 
	 * @return 是否可编辑
	 */
	public Boolean isEditable() {
		return this.properties.isEditable();
	}
	
	/**
	 * 取值时是否返回整型
	 * @return 是否整型值标志
	 */
	public Boolean isIntegerValue() {
		return this.properties.isIntegerValue();
	}

	/**
	 * 设置项目依赖
	 * @param dependency 依赖
	 */
	public void setItemsDependency(String dependency){
		this.properties.setItemsDependency(dependency);
	}
	
	/**
	 * 取得项目依赖
	 * @return 依赖
	 */
	public String getItemsDependency(){
		return this.properties.getItemsDependency();
	}
	
	/**
	 * 设置是否动态下拉项
	 * @param isDynamicItems 动态下拉项标志
	 */
	public void setDynamicItems(Boolean isDynamicItems) {
		this.properties.setDynamicItems(isDynamicItems);
	}
	
	/**
	 * 取得是否动态下拉项
	 * @return 动态下拉项标志
	 */
	public Boolean isDynamicItems() {
		return this.properties.isDynamicItems();
	}
	
	/**
	 * 设置表达式下拉项
	 * @param formulaItems 脚本元数据
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.properties.setFormulaItems(formulaItems);
	}
	
	/**
	 * 取得表达式下拉项
	 * @return 脚本元数据
	 */
	public MetaBaseScript getFormulaItems() {
		return this.properties.getFormulaItems();
	}

	public String getGroupKey() {
		return properties.getGroupKey();
	}

	public void setGroupKey(String groupKey) {
		this.properties.setGroupKey(groupKey);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.SEGMENTEDCONTROL;
	}

	/**
	 * 获取下拉项的总数
	 * 
	 * @return 下拉项总数
	 */
	public int getItemCount() {
		return this.properties.getItemCount();
	}

	/**
	 * 通过序号取得下拉项定义
	 * 
	 * @param index 序号
	 * @return 下拉项定义
	 */
	public MetaDefaultItem getItem(int index) {
		return this.properties.getItem(index);
	}

	/**
	 * 设置列表项集合
	 * @param items 列表项集合
	 */
	public void setItems(MetaListBoxItemCollection items) {
		this.properties.setItems(items);
	}
	
	/**
	 * 取得列表项集合
	 * @return 列表项集合
	 */
	public MetaListBoxItemCollection getItems() {
		return this.properties.getItems();
	}
	
	/**
	 * 取得查询定义
	 * @return 查询定义
	 */
	public MetaQueryDef getQueryDef(){
		return this.properties.getQueryDef();
	}
	
	/**
	 * 设置查询定义
	 * @param queryDef 查询定义
	 */
	public void setQueryDef(MetaQueryDef queryDef){
		this.properties.setQueryDef(queryDef);
	}
	
	/**
	 * 获取全局下拉项
	 * @return 全局下拉项
	 */
	public String getGlobalItems() {
		return this.properties.getGlobalItems();
	}
	
	/**
	 * 取得来源类型
	 * @return 来源类型
	 */
	public Integer getSourceType(){
		return this.properties.getSourceType();
	}
	
	/**
	 * 设置来源类型
	 * @param type 来源类型
	 */
	public void setSourceType(Integer type){
		this.properties.setSourceType(type);
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaSegmentedControl newObject = (MetaSegmentedControl)super.clone();
		newObject.setProperties((MetaSegmentedControlProperties)properties.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSegmentedControl();
	}

	@Override
	public MetaSegmentedControlProperties getProperties() {
		return properties;
	}
	
	/**
	 * 设置下拉框属性定义
	 * @param properties 下拉框属性定义
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaSegmentedControlProperties) properties;
	}
}
