package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;

/**
 * 标签对象，主要是显示文本，并无其他功能
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaLabel extends MetaComponent {
	private MetaLabelProperties properties = new MetaLabelProperties();
	
	public MetaLabel() {
		super();
	}
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_LABEL;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.LABEL;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

	/**
	 * 取得超出文本处理类型
	 * @return 超出文本处理类型，取值范围为{@link LabelLineBreakType}
	 */
	public Integer getLineBreakMode() {
		return properties.getLineBreakMode();
	}

	/**
	 * 设置超出文本处理类型
	 * @param lineBreakMode 超出文本处理类型，取值范围为{@link LabelLineBreakType}
	 */
	public void setLineBreakMode(Integer lineBreakMode) {
		properties.setLineBreakMode(lineBreakMode);
	}

	/**
	 * 设置图标相对路径
	 * @param icon 图标相对路径
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}
	
	/**
	 * 取得图标相对路径
	 * @return 图标相对路径
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}
	
	/**
	 * 取得是否是单行
	 * @return 是否是单行
	 */
	public Boolean isSingleLine() {
		return properties.isSingleLine();
	}

	/**
	 * 设置是否是单行
	 * @param singleLine 是否是单行
	 */
	public void setSingleLine(Boolean singleLine) {
		properties.setSingleLine(singleLine);
	}

	/**
	 * 取得最大行数，优先级低于{@link #isSingleLine()}
	 * @return 最大行数
	 */
	public Integer getMaxLines() {
		return properties.getMaxLines();
	}

	/**
	 * 设置最大行数，优先级低于{@link #isSingleLine()}
	 * @param maxLines 最大行数
	 */
	public void setMaxLines(Integer maxLines) {
		properties.setMaxLines(maxLines);
	}

	/**
	 * 取得收缩展开功能显示文本
	 * @return 收缩展开功能显示文本
	 */
	public String getExpandCaption() {
		return properties.getExpandCaption();
	}

	/**
	 * 设置收缩展开功能显示文本
	 * @param expandCaption 收缩展开功能显示文本
	 */
	public void setExpandCaption(String expandCaption) {
		properties.setExpandCaption(expandCaption);
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaLabel newObject = (MetaLabel)super.clone();
		newObject.setProperties((MetaLabelProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLabel();
	}

	@Override
	public MetaLabelProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaLabelProperties) properties;
	}
}
