package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 字体选择配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaFontPicker extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_FONTPICKER;

	/** 初始字体名称 */
	private String initFontName = "";

	/** 初始字体大小 */
	private Integer initFontSize = 12;

	/**
	 * 设置初始字体名称
	 * 
	 * @param fontName
	 *            初始字体名称
	 */
	public void setInitFontName(String fontName) {
		this.initFontName = fontName;
	}

	/**
	 * 获取初始字体名称
	 * 
	 * @return 初始字体名称
	 */
	public String getInitFontName() {
		return this.initFontName;
	}

	/**
	 * 设置初始字体大小
	 * 
	 * @param size
	 *            初始字体大小
	 */
	public void setInitFontSize(Integer size) {
		this.initFontSize = size;
	}

	/**
	 * 获取初始字体大小
	 * 
	 * @return 初始字体大小
	 */
	public Integer getInitFontSize() {
		return this.initFontSize;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.FONTPICKER;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaFontPicker newObject = (MetaFontPicker)super.clone();
		newObject.setInitFontName(initFontName);
		newObject.setInitFontSize(initFontSize);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFontPicker();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

}
